/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateMap;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelineStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(org.apache.hadoop.hdds.scm.pipelines.PipelineStateManager.class);
    private final PipelineStateMap pipelineStateMap = new PipelineStateMap();
    private final StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> stateMachine;
    private final LeaseManager<Pipeline> pipelineLeaseManager;

    PipelineStateManager(Configuration conf) {
        HashSet<HddsProtos.LifeCycleState> finalStates = new HashSet<HddsProtos.LifeCycleState>();
        long pipelineCreationLeaseTimeout = conf.getTimeDuration("ozone.scm.pipeline.creation.lease.timeout", "60s", TimeUnit.MILLISECONDS);
        this.pipelineLeaseManager = new LeaseManager("PipelineCreation", pipelineCreationLeaseTimeout);
        this.pipelineLeaseManager.start();
        finalStates.add(HddsProtos.LifeCycleState.CLOSED);
        this.stateMachine = new StateMachine((Enum)HddsProtos.LifeCycleState.ALLOCATED, finalStates);
        this.initializeStateMachine();
    }

    private void initializeStateMachine() {
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.ALLOCATED, (Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleEvent.CREATE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleEvent.CREATED);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleEvent.FINALIZE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.CLOSE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.TIMEOUT);
    }

    Pipeline updatePipelineState(PipelineID pipelineID, HddsProtos.LifeCycleEvent event) throws IOException {
        Pipeline pipeline = null;
        try {
            pipeline = this.pipelineStateMap.getPipeline(pipelineID);
            HddsProtos.LifeCycleState newState = (HddsProtos.LifeCycleState)this.stateMachine.getNextState((Enum)pipeline.getLifeCycleState(), (Enum)event);
            return this.pipelineStateMap.updatePipelineState(pipeline.getID(), newState);
        }
        catch (InvalidStateTransitionException ex) {
            String error = String.format("Failed to update pipeline state %s, reason: invalid state transition from state: %s upon event: %s.", pipeline.getID(), pipeline.getLifeCycleState(), event);
            LOG.error(error);
            throw new SCMException(error, SCMException.ResultCodes.FAILED_TO_CHANGE_PIPELINE_STATE);
        }
    }

    void addPipeline(Pipeline pipeline) throws IOException {
        this.pipelineStateMap.addPipeline(pipeline);
    }

    void addContainerToPipeline(PipelineID pipelineId, ContainerID containerID) throws IOException {
        this.pipelineStateMap.addContainerToPipeline(pipelineId, containerID);
    }

    Pipeline getPipeline(PipelineID pipelineID) throws IOException {
        return this.pipelineStateMap.getPipeline(pipelineID);
    }

    List<Pipeline> getPipelines(HddsProtos.ReplicationType type) {
        return this.pipelineStateMap.getPipelines(type);
    }

    Set<ContainerID> getContainers(PipelineID pipelineID) throws IOException {
        return this.pipelineStateMap.getContainers(pipelineID);
    }

    void removePipeline(PipelineID pipelineID) throws IOException {
        this.pipelineStateMap.removePipeline(pipelineID);
    }

    void removeContainerFromPipeline(PipelineID pipelineID, ContainerID containerID) throws IOException {
        this.pipelineStateMap.removeContainerFromPipeline(pipelineID, containerID);
    }

    void close() {
        this.pipelineLeaseManager.shutdown();
    }
}

