/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SimplePipelineProvider;

public final class PipelineFactory {
    private Map<HddsProtos.ReplicationType, PipelineProvider> providers = new HashMap<HddsProtos.ReplicationType, PipelineProvider>();

    PipelineFactory(NodeManager nodeManager, PipelineStateManager stateManager) {
        this.providers.put(HddsProtos.ReplicationType.STAND_ALONE, new SimplePipelineProvider(nodeManager));
        this.providers.put(HddsProtos.ReplicationType.RATIS, new RatisPipelineProvider(nodeManager, stateManager));
    }

    public Pipeline create(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) throws IOException {
        return this.providers.get(type).create(factor);
    }

    public Pipeline create(HddsProtos.ReplicationType type, List<DatanodeDetails> nodes) throws IOException {
        return this.providers.get(type).create(nodes);
    }
}

