/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.states.NodeAlreadyExistsException;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;

public class NodeStateMap {
    private final ConcurrentHashMap<UUID, DatanodeInfo> nodeMap;
    private final ConcurrentHashMap<HddsProtos.NodeState, Set<UUID>> stateMap;
    private final ConcurrentHashMap<UUID, SCMNodeStat> nodeStats;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public NodeStateMap() {
        this.nodeMap = new ConcurrentHashMap();
        this.stateMap = new ConcurrentHashMap();
        this.nodeStats = new ConcurrentHashMap();
        this.initStateMap();
    }

    private void initStateMap() {
        for (HddsProtos.NodeState state : HddsProtos.NodeState.values()) {
            this.stateMap.put(state, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(DatanodeDetails datanodeDetails, HddsProtos.NodeState nodeState) throws NodeAlreadyExistsException {
        this.lock.writeLock().lock();
        try {
            UUID id = datanodeDetails.getUuid();
            if (this.nodeMap.containsKey(id)) {
                throw new NodeAlreadyExistsException("Node UUID: " + id);
            }
            this.nodeMap.put(id, new DatanodeInfo(datanodeDetails));
            this.stateMap.get(nodeState).add(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeState(UUID nodeId, HddsProtos.NodeState currentState, HddsProtos.NodeState newState) throws NodeNotFoundException {
        block4: {
            this.lock.writeLock().lock();
            try {
                if (this.stateMap.get(currentState).remove(nodeId)) {
                    this.stateMap.get(newState).add(nodeId);
                    break block4;
                }
                throw new NodeNotFoundException("Node UUID: " + nodeId + ", not found in state: " + currentState);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public DatanodeDetails getNodeDetails(UUID uuid) throws NodeNotFoundException {
        return this.getNodeInfo(uuid);
    }

    public DatanodeInfo getNodeInfo(UUID uuid) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            if (this.nodeMap.containsKey(uuid)) {
                DatanodeInfo datanodeInfo = this.nodeMap.get(uuid);
                return datanodeInfo;
            }
            throw new NodeNotFoundException("Node UUID: " + uuid);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<UUID> getNodes(HddsProtos.NodeState state) {
        this.lock.readLock().lock();
        try {
            LinkedList<UUID> linkedList = new LinkedList<UUID>((Collection)this.stateMap.get(state));
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<UUID> getAllNodes() {
        this.lock.readLock().lock();
        try {
            LinkedList<UUID> linkedList = new LinkedList<UUID>(this.nodeMap.keySet());
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getNodeCount(HddsProtos.NodeState state) {
        this.lock.readLock().lock();
        try {
            int n = this.stateMap.get(state).size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getTotalNodeCount() {
        this.lock.readLock().lock();
        try {
            int n = this.nodeMap.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public HddsProtos.NodeState getNodeState(UUID uuid) throws NodeNotFoundException {
        this.lock.readLock().lock();
        try {
            for (Map.Entry<HddsProtos.NodeState, Set<UUID>> entry : this.stateMap.entrySet()) {
                if (!entry.getValue().contains(uuid)) continue;
                HddsProtos.NodeState nodeState = entry.getKey();
                return nodeState;
            }
            throw new NodeNotFoundException("Node UUID: " + uuid);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(UUID uuid) throws NodeNotFoundException {
        this.lock.writeLock().lock();
        try {
            if (this.nodeMap.containsKey(uuid)) {
                for (Map.Entry<HddsProtos.NodeState, Set<UUID>> entry : this.stateMap.entrySet()) {
                    if (entry.getValue().remove(uuid)) break;
                    this.nodeMap.remove(uuid);
                }
                throw new NodeNotFoundException("Node UUID: " + uuid);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public SCMNodeStat getNodeStat(UUID uuid) throws NodeNotFoundException {
        SCMNodeStat stat = this.nodeStats.get(uuid);
        if (stat == null) {
            throw new NodeNotFoundException("Node UUID: " + uuid);
        }
        return stat;
    }

    public Map<UUID, SCMNodeStat> getNodeStats() {
        return Collections.unmodifiableMap(this.nodeStats);
    }

    public void setNodeStat(UUID uuid, SCMNodeStat newstat) {
        this.nodeStats.put(uuid, newstat);
    }

    public SCMNodeStat removeNodeStat(UUID uuid) throws NodeNotFoundException {
        SCMNodeStat stat = this.nodeStats.remove(uuid);
        if (stat == null) {
            throw new NodeNotFoundException("Node UUID: " + uuid);
        }
        return stat;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Total number of nodes: ").append(this.getTotalNodeCount());
        for (HddsProtos.NodeState state : HddsProtos.NodeState.values()) {
            builder.append("Number of nodes in ").append(state).append(" state: ").append(this.getNodeCount(state));
        }
        return builder.toString();
    }
}

