/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.VersionInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.CommandQueue;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStateManager;
import org.apache.hadoop.hdds.scm.node.states.NodeAlreadyExistsException;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.node.states.ReportResult;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.protocol.StorageContainerNodeProtocol;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMNodeManager
implements NodeManager,
StorageContainerNodeProtocol {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMNodeManager.class);
    private final NodeStateManager nodeStateManager;
    private SCMNodeStat scmStat;
    private final String clusterID;
    private final VersionInfo version;
    private final CommandQueue commandQueue;
    private ObjectName nmInfoBean;
    private final StorageContainerManager scmManager;

    public SCMNodeManager(OzoneConfiguration conf, String clusterID, StorageContainerManager scmManager, EventPublisher eventPublisher) throws IOException {
        this.nodeStateManager = new NodeStateManager((Configuration)conf, eventPublisher);
        this.scmStat = new SCMNodeStat();
        this.clusterID = clusterID;
        this.version = VersionInfo.getLatestVersion();
        this.commandQueue = new CommandQueue();
        this.scmManager = scmManager;
        LOG.info("Entering startup chill mode.");
        this.registerMXBean();
    }

    private void registerMXBean() {
        this.nmInfoBean = MBeans.register((String)"SCMNodeManager", (String)"SCMNodeManagerInfo", (Object)this);
    }

    private void unregisterMXBean() {
        if (this.nmInfoBean != null) {
            MBeans.unregister((ObjectName)this.nmInfoBean);
            this.nmInfoBean = null;
        }
    }

    @Override
    public void removeNode(DatanodeDetails node) throws NodeNotFoundException {
        this.nodeStateManager.removeNode(node);
    }

    @Override
    public List<DatanodeDetails> getNodes(HddsProtos.NodeState nodestate) {
        return this.nodeStateManager.getNodes(nodestate);
    }

    @Override
    public List<DatanodeDetails> getAllNodes() {
        return this.nodeStateManager.getAllNodes();
    }

    @Override
    public int getNodeCount(HddsProtos.NodeState nodestate) {
        return this.nodeStateManager.getNodeCount(nodestate);
    }

    @Override
    public HddsProtos.NodeState getNodeState(DatanodeDetails datanodeDetails) {
        try {
            return this.nodeStateManager.getNodeState(datanodeDetails);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    private void updateNodeStat(UUID dnId, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport) {
        SCMNodeStat stat;
        try {
            stat = this.nodeStateManager.getNodeStat(dnId);
        }
        catch (NodeNotFoundException e) {
            LOG.debug("SCM updateNodeStat based on heartbeat from previous dead datanode {}", (Object)dnId);
            stat = new SCMNodeStat();
        }
        if (nodeReport != null && nodeReport.getStorageReportCount() > 0) {
            long totalCapacity = 0L;
            long totalRemaining = 0L;
            long totalScmUsed = 0L;
            List storageReports = nodeReport.getStorageReportList();
            for (StorageContainerDatanodeProtocolProtos.StorageReportProto report : storageReports) {
                totalCapacity += report.getCapacity();
                totalRemaining += report.getRemaining();
                totalScmUsed += report.getScmUsed();
            }
            this.scmStat.subtract(stat);
            stat.set(totalCapacity, totalScmUsed, totalRemaining);
            this.scmStat.add(stat);
        }
        this.nodeStateManager.setNodeStat(dnId, stat);
    }

    @Override
    public void close() throws IOException {
        this.unregisterMXBean();
    }

    public VersionResponse getVersion(StorageContainerDatanodeProtocolProtos.SCMVersionRequestProto versionRequest) {
        return VersionResponse.newBuilder().setVersion(this.version.getVersion()).addValue("scmUuid", this.scmManager.getScmStorage().getScmId()).addValue("clusterID", this.scmManager.getScmStorage().getClusterID()).build();
    }

    public RegisteredCommand register(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport, StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto) {
        InetAddress dnAddress = Server.getRemoteIp();
        if (dnAddress != null) {
            datanodeDetails.setHostName(dnAddress.getHostName());
            datanodeDetails.setIpAddress(dnAddress.getHostAddress());
        }
        UUID dnId = datanodeDetails.getUuid();
        try {
            this.nodeStateManager.addNode(datanodeDetails);
            this.nodeStateManager.setNodeStat(dnId, new SCMNodeStat());
            this.updateNodeStat(datanodeDetails.getUuid(), nodeReport);
            LOG.info("Registered Data node : {}", (Object)datanodeDetails);
        }
        catch (NodeAlreadyExistsException e) {
            LOG.trace("Datanode is already registered. Datanode: {}", (Object)datanodeDetails.toString());
        }
        return RegisteredCommand.newBuilder().setErrorCode(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.success).setDatanodeUUID(datanodeDetails.getUuidString()).setClusterID(this.clusterID).setHostname(datanodeDetails.getHostName()).setIpAddress(datanodeDetails.getIpAddress()).build();
    }

    public List<SCMCommand> processHeartbeat(DatanodeDetails datanodeDetails) {
        Preconditions.checkNotNull((Object)datanodeDetails, (Object)"Heartbeat is missing DatanodeDetails.");
        try {
            this.nodeStateManager.updateLastHeartbeatTime(datanodeDetails);
        }
        catch (NodeNotFoundException e) {
            LOG.error("SCM trying to process heartbeat from an unregistered node {}. Ignoring the heartbeat.", (Object)datanodeDetails);
        }
        return this.commandQueue.getCommand(datanodeDetails.getUuid());
    }

    public Boolean isNodeRegistered(DatanodeDetails datanodeDetails) {
        try {
            this.nodeStateManager.getNode(datanodeDetails);
            return true;
        }
        catch (NodeNotFoundException e) {
            return false;
        }
    }

    @Override
    public void processNodeReport(UUID dnUuid, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport) {
        this.updateNodeStat(dnUuid, nodeReport);
    }

    @Override
    public SCMNodeStat getStats() {
        return new SCMNodeStat(this.scmStat);
    }

    @Override
    public Map<UUID, SCMNodeStat> getNodeStats() {
        return this.nodeStateManager.getNodeStatsMap();
    }

    @Override
    public SCMNodeMetric getNodeStat(DatanodeDetails datanodeDetails) {
        try {
            return new SCMNodeMetric(this.nodeStateManager.getNodeStat(datanodeDetails.getUuid()));
        }
        catch (NodeNotFoundException e) {
            LOG.info("SCM getNodeStat from a decommissioned or removed datanode {}", (Object)datanodeDetails.getUuid());
            return null;
        }
    }

    @Override
    public Map<String, Integer> getNodeCount() {
        HashMap<String, Integer> nodeCountMap = new HashMap<String, Integer>();
        for (HddsProtos.NodeState state : HddsProtos.NodeState.values()) {
            nodeCountMap.put(state.toString(), this.getNodeCount(state));
        }
        return nodeCountMap;
    }

    @Override
    public Set<PipelineID> getPipelineByDnID(UUID dnId) {
        return this.nodeStateManager.getPipelineByDnID(dnId);
    }

    @Override
    public void addPipeline(Pipeline pipeline) {
        this.nodeStateManager.addPipeline(pipeline);
    }

    @Override
    public void removePipeline(Pipeline pipeline) {
        this.nodeStateManager.removePipeline(pipeline);
    }

    @Override
    public void setContainersForDatanode(UUID uuid, Set<ContainerID> containerIds) throws SCMException {
        this.nodeStateManager.setContainersForDatanode(uuid, containerIds);
    }

    @Override
    public ReportResult<ContainerID> processContainerReport(UUID uuid, Set<ContainerID> containerIds) {
        return this.nodeStateManager.processContainerReport(uuid, containerIds);
    }

    @Override
    public Set<ContainerID> getContainers(UUID uuid) {
        return this.nodeStateManager.getContainers(uuid);
    }

    @Override
    public void addDatanodeInContainerMap(UUID uuid, Set<ContainerID> containerIDs) throws SCMException {
        this.nodeStateManager.addDatanodeInContainerMap(uuid, containerIDs);
    }

    @Override
    public void addDatanodeCommand(UUID dnId, SCMCommand command) {
        this.commandQueue.addCommand(dnId, command);
    }

    public void onMessage(CommandForDatanode commandForDatanode, EventPublisher ignored) {
        this.addDatanodeCommand(commandForDatanode.getDatanodeId(), commandForDatanode.getCommand());
    }

    @Override
    public void processDeadNode(UUID dnUuid) {
        try {
            SCMNodeStat stat = this.nodeStateManager.getNodeStat(dnUuid);
            if (stat != null) {
                LOG.trace("Update stat values as Datanode {} is dead.", (Object)dnUuid);
                this.scmStat.subtract(stat);
                stat.set(0L, 0L, 0L);
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn("Can't update stats based on message of dead Datanode {}, it doesn't exist or decommissioned already.", (Object)dnUuid);
        }
    }

    @Override
    public List<SCMCommand> getCommandQueue(UUID dnID) {
        return this.commandQueue.getCommand(dnID);
    }
}

