/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.util.Time;

public class DatanodeInfo
extends DatanodeDetails {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile long lastHeartbeatTime = Time.monotonicNow();
    private long lastStatsUpdatedTime;
    private List<StorageContainerDatanodeProtocolProtos.StorageReportProto> storageReports;

    public DatanodeInfo(DatanodeDetails datanodeDetails) {
        super(datanodeDetails);
    }

    public void updateLastHeartbeatTime() {
        try {
            this.lock.writeLock().lock();
            this.lastHeartbeatTime = Time.monotonicNow();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getLastHeartbeatTime() {
        try {
            this.lock.readLock().lock();
            long l = this.lastHeartbeatTime;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void updateStorageReports(List<StorageContainerDatanodeProtocolProtos.StorageReportProto> reports) {
        try {
            this.lock.writeLock().lock();
            this.lastStatsUpdatedTime = Time.monotonicNow();
            this.storageReports = reports;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<StorageContainerDatanodeProtocolProtos.StorageReportProto> getStorageReports() {
        try {
            this.lock.readLock().lock();
            List<StorageContainerDatanodeProtocolProtos.StorageReportProto> list = this.storageReports;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getLastStatsUpdatedTime() {
        return this.lastStatsUpdatedTime;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

