/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;

public class CommandQueue {
    private static final List<SCMCommand> DEFAULT_LIST = new LinkedList<SCMCommand>();
    private final Map<UUID, Commands> commandMap = new HashMap<UUID, Commands>();
    private final Lock lock = new ReentrantLock();
    private long commandsInQueue = 0L;

    public long getCommandsInQueue() {
        return this.commandsInQueue;
    }

    @VisibleForTesting
    public void clear() {
        this.lock.lock();
        try {
            this.commandMap.clear();
            this.commandsInQueue = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SCMCommand> getCommand(UUID datanodeUuid) {
        this.lock.lock();
        try {
            Commands cmds = this.commandMap.remove(datanodeUuid);
            List<SCMCommand> cmdList = null;
            if (cmds != null) {
                cmdList = cmds.getCommands();
                this.commandsInQueue -= cmdList.size() > 0 ? (long)cmdList.size() : 0L;
                Preconditions.checkState((this.commandsInQueue >= 0L ? 1 : 0) != 0);
            }
            List<SCMCommand> list = cmds == null ? DEFAULT_LIST : cmdList;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCommand(UUID datanodeUuid, SCMCommand command) {
        this.lock.lock();
        try {
            if (this.commandMap.containsKey(datanodeUuid)) {
                this.commandMap.get(datanodeUuid).add(command);
            } else {
                this.commandMap.put(datanodeUuid, new Commands(command));
            }
            ++this.commandsInQueue;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Commands {
        private long updateTime = 0L;
        private long readTime = 0L;
        private List<SCMCommand> commands = new LinkedList<SCMCommand>();

        Commands() {
        }

        Commands(SCMCommand command) {
            this();
            this.add(command);
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public long getReadTime() {
            return this.readTime;
        }

        public void add(SCMCommand command) {
            this.commands.add(command);
            this.updateTime = Time.monotonicNow();
        }

        public List<SCMCommand> getCommands() {
            List<SCMCommand> temp = this.commands;
            this.commands = new LinkedList<SCMCommand>();
            this.readTime = Time.monotonicNow();
            return temp;
        }
    }
}

