/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerStateManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationCommandWatcher;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationQueue;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationRequest;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.IdentifiableEventPayload;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationManager
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationManager.class);
    private ReplicationQueue replicationQueue;
    private ContainerPlacementPolicy containerPlacement;
    private EventPublisher eventPublisher;
    private ReplicationCommandWatcher replicationCommandWatcher;
    private boolean running = true;
    private ContainerStateManager containerStateManager;

    public ReplicationManager(ContainerPlacementPolicy containerPlacement, ContainerStateManager containerStateManager, EventQueue eventQueue, LeaseManager<Long> commandWatcherLeaseManager) {
        this.containerPlacement = containerPlacement;
        this.containerStateManager = containerStateManager;
        this.eventPublisher = eventQueue;
        this.replicationCommandWatcher = new ReplicationCommandWatcher((Event<ReplicationRequestToRepeat>)SCMEvents.TRACK_REPLICATE_COMMAND, (Event<ReplicationCompleted>)SCMEvents.REPLICATION_COMPLETE, commandWatcherLeaseManager);
        this.replicationQueue = new ReplicationQueue();
        eventQueue.addHandler(SCMEvents.REPLICATE_CONTAINER, (replicationRequest, publisher) -> this.replicationQueue.add((ReplicationRequest)replicationRequest));
        this.replicationCommandWatcher.start(eventQueue);
    }

    public void start() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Replication Manager").build();
        threadFactory.newThread(this).start();
    }

    @Override
    public void run() {
        while (this.running) {
            ReplicationRequest request = null;
            try {
                request = this.replicationQueue.take();
                ContainerID containerID = new ContainerID(request.getContainerId());
                ContainerInfo containerInfo = this.containerStateManager.getContainer(containerID);
                Preconditions.checkNotNull((Object)containerInfo, (Object)("No information about the container " + request.getContainerId()));
                Preconditions.checkState((containerInfo.getState() == HddsProtos.LifeCycleState.CLOSED ? 1 : 0) != 0, (Object)"Container should be in closed state");
                ArrayList<DatanodeDetails> datanodesWithReplicas = new ArrayList<DatanodeDetails>(this.getCurrentReplicas(request));
                if (datanodesWithReplicas.size() == 0) {
                    LOG.warn("Container {} should be replicated but can't find any existing replicas", (Object)containerID);
                    return;
                }
                ReplicationRequest finalRequest = request;
                int inFlightReplications = this.replicationCommandWatcher.getTimeoutEvents(e -> ((ReplicationRequestToRepeat)e).request.getContainerId() == finalRequest.getContainerId()).size();
                int deficit = request.getExpecReplicationCount() - datanodesWithReplicas.size() - inFlightReplications;
                if (deficit > 0) {
                    List<DatanodeDetails> selectedDatanodes = this.containerPlacement.chooseDatanodes(datanodesWithReplicas, deficit, containerInfo.getUsedBytes());
                    for (DatanodeDetails datanode : selectedDatanodes) {
                        ReplicateContainerCommand replicateCommand = new ReplicateContainerCommand(containerID.getId(), datanodesWithReplicas);
                        this.eventPublisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(datanode.getUuid(), (SCMCommand)replicateCommand));
                        ReplicationRequestToRepeat timeoutEvent = new ReplicationRequestToRepeat(replicateCommand.getId(), request);
                        this.eventPublisher.fireEvent(SCMEvents.TRACK_REPLICATE_COMMAND, (Object)timeoutEvent);
                    }
                    continue;
                }
                if (deficit >= 0) continue;
            }
            catch (Exception e2) {
                LOG.error("Can't replicate container {}", (Object)request, (Object)e2);
            }
        }
    }

    @VisibleForTesting
    protected Set<DatanodeDetails> getCurrentReplicas(ReplicationRequest request) throws IOException {
        return this.containerStateManager.getContainerReplicas(new ContainerID(request.getContainerId()));
    }

    @VisibleForTesting
    public ReplicationQueue getReplicationQueue() {
        return this.replicationQueue;
    }

    public void stop() {
        this.running = false;
    }

    public static class ReplicationCompleted
    implements IdentifiableEventPayload {
        private final long uuid;

        public ReplicationCompleted(long uuid) {
            this.uuid = uuid;
        }

        public long getId() {
            return this.uuid;
        }
    }

    public static class ReplicationRequestToRepeat
    implements IdentifiableEventPayload {
        private final long commandId;
        private final ReplicationRequest request;

        public ReplicationRequestToRepeat(long commandId, ReplicationRequest request) {
            this.commandId = commandId;
            this.request = request;
        }

        public ReplicationRequest getRequest() {
            return this.request;
        }

        public long getId() {
            return this.commandId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicationRequestToRepeat that = (ReplicationRequestToRepeat)o;
            return Objects.equals(this.request, that.request);
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }
    }
}

