/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationRequest;
import org.apache.hadoop.hdds.scm.container.states.ContainerState;
import org.apache.hadoop.hdds.scm.container.states.ContainerStateMap;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipelines.PipelineSelector;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerStateManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerStateManager.class);
    private final StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> stateMachine;
    private final long containerSize;
    private final ConcurrentHashMap<ContainerState, ContainerID> lastUsedMap;
    private final ContainerStateMap containers;
    private final AtomicLong containerCount;

    public ContainerStateManager(Configuration configuration, ContainerManager containerManager, PipelineSelector pipelineSelector) {
        HashSet<HddsProtos.LifeCycleState> finalStates = new HashSet<HddsProtos.LifeCycleState>();
        finalStates.add(HddsProtos.LifeCycleState.OPEN);
        finalStates.add(HddsProtos.LifeCycleState.CLOSED);
        finalStates.add(HddsProtos.LifeCycleState.DELETED);
        this.stateMachine = new StateMachine((Enum)HddsProtos.LifeCycleState.ALLOCATED, finalStates);
        this.initializeStateMachine();
        this.containerSize = (long)configuration.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.lastUsedMap = new ConcurrentHashMap();
        this.containerCount = new AtomicLong(0L);
        this.containers = new ContainerStateMap();
    }

    public List<ContainerInfo> getAllContainers() {
        ArrayList<ContainerInfo> list = new ArrayList<ContainerInfo>();
        this.containers.getContainerMap().forEach((key, value) -> list.add((ContainerInfo)value));
        return list;
    }

    private void initializeStateMachine() {
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.ALLOCATED, (Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleEvent.CREATE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleEvent.CREATED);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleEvent.FINALIZE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.CLOSE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleEvent.DELETE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CREATING, (Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleEvent.TIMEOUT);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleState.DELETED, (Enum)HddsProtos.LifeCycleEvent.CLEANUP);
    }

    public void addExistingContainer(ContainerInfo containerInfo) throws SCMException {
        this.containers.addContainer(containerInfo);
        long containerID = containerInfo.getContainerID();
        if (this.containerCount.get() < containerID) {
            this.containerCount.set(containerID);
        }
    }

    public ContainerWithPipeline allocateContainer(PipelineSelector selector, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor replicationFactor, String owner) throws IOException {
        Pipeline pipeline = selector.getReplicationPipeline(type, replicationFactor);
        Preconditions.checkNotNull((Object)pipeline, (String)"Pipeline type=%s/replication=%s couldn't be found for the new container. Do you have enough nodes?", (Object[])new Object[]{type, replicationFactor});
        long containerID = this.containerCount.incrementAndGet();
        ContainerInfo containerInfo = new ContainerInfo.Builder().setState(HddsProtos.LifeCycleState.ALLOCATED).setPipelineID(pipeline.getId()).setAllocatedBytes(0L).setUsedBytes(0L).setNumberOfKeys(0L).setStateEnterTime(Time.monotonicNow()).setOwner(owner).setContainerID(containerID).setDeleteTransactionId(0L).setReplicationFactor(replicationFactor).setReplicationType(pipeline.getType()).build();
        selector.addContainerToPipeline(pipeline.getId(), containerID);
        Preconditions.checkNotNull((Object)containerInfo);
        this.containers.addContainer(containerInfo);
        LOG.trace("New container allocated: {}", (Object)containerInfo);
        return new ContainerWithPipeline(containerInfo, pipeline);
    }

    public ContainerInfo updateContainerState(ContainerInfo info, HddsProtos.LifeCycleEvent event) throws SCMException {
        HddsProtos.LifeCycleState newState;
        try {
            newState = (HddsProtos.LifeCycleState)this.stateMachine.getNextState((Enum)info.getState(), (Enum)event);
        }
        catch (InvalidStateTransitionException ex) {
            String error = String.format("Failed to update container state %s, reason: invalid state transition from state: %s upon event: %s.", info.getContainerID(), info.getState(), event);
            LOG.error(error);
            throw new SCMException(error, SCMException.ResultCodes.FAILED_TO_CHANGE_CONTAINER_STATE);
        }
        Preconditions.checkNotNull((Object)newState);
        this.containers.updateState(info, info.getState(), newState);
        return this.containers.getContainerInfo(info);
    }

    public ContainerInfo updateContainerInfo(ContainerInfo info) throws SCMException {
        this.containers.updateContainerInfo(info);
        return this.containers.getContainerInfo(info);
    }

    public void updateDeleteTransactionId(Map<Long, Long> deleteTransactionMap) {
        for (Map.Entry<Long, Long> entry : deleteTransactionMap.entrySet()) {
            this.containers.getContainerMap().get(ContainerID.valueof((long)entry.getKey())).updateDeleteTransactionId(entry.getValue().longValue());
        }
    }

    public ContainerInfo getMatchingContainer(long size, String owner, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.LifeCycleState state) {
        ContainerInfo selectedContainer;
        NavigableSet<ContainerID> resultSet;
        NavigableSet<ContainerID> matchingSet = this.containers.getMatchingContainerIDs(state, owner, factor, type);
        if (matchingSet == null || matchingSet.size() == 0) {
            return null;
        }
        ContainerState key = new ContainerState(owner, type, factor);
        ContainerID lastID = this.lastUsedMap.get(key);
        if (lastID == null) {
            lastID = (ContainerID)matchingSet.first();
        }
        if ((resultSet = matchingSet.tailSet(lastID, false)).size() == 0) {
            resultSet = matchingSet;
        }
        if ((selectedContainer = this.findContainerWithSpace(size, resultSet, owner)) == null) {
            resultSet = matchingSet.headSet(lastID, true);
            selectedContainer = this.findContainerWithSpace(size, resultSet, owner);
        }
        if (selectedContainer != null) {
            selectedContainer.updateAllocatedBytes(size);
        }
        return selectedContainer;
    }

    private ContainerInfo findContainerWithSpace(long size, NavigableSet<ContainerID> searchSet, String owner) {
        for (ContainerID id : searchSet) {
            ContainerInfo containerInfo = this.containers.getContainerInfo(id);
            if (containerInfo.getAllocatedBytes() + size > this.containerSize) continue;
            containerInfo.updateLastUsedTime();
            ContainerState key = new ContainerState(owner, containerInfo.getReplicationType(), containerInfo.getReplicationFactor());
            this.lastUsedMap.put(key, containerInfo.containerID());
            return containerInfo;
        }
        return null;
    }

    public NavigableSet<ContainerID> getMatchingContainerIDs(String owner, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.LifeCycleState state) {
        return this.containers.getMatchingContainerIDs(state, owner, factor, type);
    }

    public ContainerWithPipeline getContainer(PipelineSelector selector, ContainerID containerID) {
        ContainerInfo info = this.containers.getContainerInfo(containerID.getId());
        Pipeline pipeline = selector.getPipeline(info.getPipelineID());
        return new ContainerWithPipeline(info, pipeline);
    }

    public ContainerInfo getContainer(ContainerID containerID) {
        return this.containers.getContainerInfo(containerID);
    }

    @Override
    public void close() throws IOException {
    }

    public Set<DatanodeDetails> getContainerReplicas(ContainerID containerID) throws SCMException {
        return this.containers.getContainerReplicas(containerID);
    }

    public void addContainerReplica(ContainerID containerID, DatanodeDetails dn) {
        this.containers.addContainerReplica(containerID, dn);
    }

    public boolean removeContainerReplica(ContainerID containerID, DatanodeDetails dn) throws SCMException {
        return this.containers.removeContainerReplica(containerID, dn);
    }

    public ReplicationRequest checkReplicationState(ContainerID containerID) throws SCMException {
        int expectedReplicas;
        int existingReplicas = this.getContainerReplicas(containerID).size();
        if (existingReplicas != (expectedReplicas = this.getContainer(containerID).getReplicationFactor().getNumber())) {
            return new ReplicationRequest(containerID.getId(), existingReplicas, expectedReplicas);
        }
        return null;
    }

    public boolean isOpen(ContainerID containerID) {
        Preconditions.checkNotNull((Object)containerID);
        ContainerInfo container = (ContainerInfo)Preconditions.checkNotNull((Object)this.getContainer(containerID), (Object)("Container can't be found " + containerID));
        return container.isContainerOpen();
    }

    @VisibleForTesting
    public ContainerStateMap getContainerStateMap() {
        return this.containers;
    }
}

