/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.utils.BatchOperation;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.MetadataStoreBuilder;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedBlockLogImpl
implements DeletedBlockLog,
EventHandler<CommandStatusReportHandler.DeleteBlockStatus> {
    public static final Logger LOG = LoggerFactory.getLogger(DeletedBlockLogImpl.class);
    private static final byte[] LATEST_TXID = DFSUtil.string2Bytes((String)"#LATEST_TXID#");
    private final int maxRetry;
    private final MetadataStore deletedStore;
    private final ContainerManager containerManager;
    private final Lock lock;
    private long lastTxID;
    private Map<Long, Set<UUID>> transactionToDNsCommitMap;

    public DeletedBlockLogImpl(Configuration conf, ContainerManager containerManager) throws IOException {
        this.maxRetry = conf.getInt("ozone.scm.block.deletion.max.retry", 4096);
        File metaDir = ServerUtils.getOzoneMetaDirPath((Configuration)conf);
        String scmMetaDataDir = metaDir.getPath();
        File deletedLogDbPath = new File(scmMetaDataDir, "deletedBlock.db");
        int cacheSize = conf.getInt("ozone.scm.db.cache.size.mb", 128);
        this.deletedStore = MetadataStoreBuilder.newBuilder().setCreateIfMissing(true).setConf(conf).setDbFile(deletedLogDbPath).setCacheSize((long)cacheSize * 0x100000L).build();
        this.containerManager = containerManager;
        this.lock = new ReentrantLock();
        this.lastTxID = this.findLatestTxIDInStore();
        this.transactionToDNsCommitMap = new ConcurrentHashMap<Long, Set<UUID>>();
    }

    @VisibleForTesting
    public MetadataStore getDeletedStore() {
        return this.deletedStore;
    }

    private long findLatestTxIDInStore() throws IOException {
        long txid = 0L;
        byte[] value = this.deletedStore.get(LATEST_TXID);
        if (value != null) {
            txid = Longs.fromByteArray((byte[])value);
        }
        return txid;
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getFailedTransactions() throws IOException {
        this.lock.lock();
        try {
            ArrayList failedTXs = Lists.newArrayList();
            this.deletedStore.iterate(null, (key, value) -> {
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX;
                if (!Arrays.equals(LATEST_TXID, key) && (delTX = StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.parseFrom((byte[])value)).getCount() == -1) {
                    failedTXs.add(delTX);
                }
                return true;
            });
            ArrayList arrayList = failedTXs;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementCount(List<Long> txIDs) throws IOException {
        BatchOperation batch = new BatchOperation();
        this.lock.lock();
        try {
            for (Long txID : txIDs) {
                try {
                    byte[] deleteBlockBytes = this.deletedStore.get(Longs.toByteArray((long)txID));
                    if (deleteBlockBytes == null) {
                        LOG.warn("Delete txID {} not found", (Object)txID);
                        continue;
                    }
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block = StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.parseFrom((byte[])deleteBlockBytes);
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.Builder builder = block.toBuilder();
                    int currentCount = block.getCount();
                    if (currentCount > -1) {
                        builder.setCount(++currentCount);
                    }
                    if (currentCount > this.maxRetry) {
                        builder.setCount(-1);
                    }
                    this.deletedStore.put(Longs.toByteArray((long)txID), builder.build().toByteArray());
                }
                catch (IOException ex) {
                    LOG.warn("Cannot increase count for txID " + txID, (Throwable)ex);
                }
            }
            this.deletedStore.writeBatch(batch);
        }
        finally {
            this.lock.unlock();
        }
    }

    private StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction constructNewTransaction(long txID, long containerID, List<Long> blocks) {
        return StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder().setTxID(txID).setContainerID(containerID).addAllLocalID(blocks).setCount(0).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransactions(List<StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult> transactionResults, UUID dnID) {
        this.lock.lock();
        try {
            for (StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult transactionResult : transactionResults) {
                Long containerId;
                Set<UUID> dnsWithCommittedTxn;
                long txID;
                block9: {
                    if (this.isTransactionFailed(transactionResult)) continue;
                    txID = transactionResult.getTxID();
                    dnsWithCommittedTxn = this.transactionToDNsCommitMap.get(txID);
                    containerId = transactionResult.getContainerID();
                    if (dnsWithCommittedTxn != null) break block9;
                    LOG.warn("Transaction txId={} commit by dnId={} for containerID={} failed. Corresponding entry not found.", new Object[]{txID, dnID, containerId});
                    return;
                }
                try {
                    List containerDns;
                    dnsWithCommittedTxn.add(dnID);
                    Pipeline pipeline = this.containerManager.getContainerWithPipeline(containerId).getPipeline();
                    Collection containerDnsDetails = pipeline.getDatanodes().values();
                    if (Math.min(containerDnsDetails.size(), dnsWithCommittedTxn.size()) >= pipeline.getFactor().getNumber() && dnsWithCommittedTxn.containsAll(containerDns = containerDnsDetails.stream().map(DatanodeDetails::getUuid).collect(Collectors.toList()))) {
                        this.transactionToDNsCommitMap.remove(txID);
                        LOG.debug("Purging txId={} from block deletion log", (Object)txID);
                        this.deletedStore.delete(Longs.toByteArray((long)txID));
                    }
                    LOG.debug("Datanode txId={} containerId={} committed by dnId={}", new Object[]{txID, containerId, dnID});
                }
                catch (IOException e) {
                    LOG.warn("Could not commit delete block transaction: " + transactionResult.getTxID(), (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isTransactionFailed(StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got block deletion ACK from datanode, TXIDs={}, success={}", (Object)result.getTxID(), (Object)result.getSuccess());
        }
        if (!result.getSuccess()) {
            LOG.warn("Got failed ACK for TXID={}, prepare to resend the TX in next interval", (Object)result.getTxID());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransaction(long containerID, List<Long> blocks) throws IOException {
        BatchOperation batch = new BatchOperation();
        this.lock.lock();
        try {
            StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx = this.constructNewTransaction(this.lastTxID + 1L, containerID, blocks);
            byte[] key = Longs.toByteArray((long)(this.lastTxID + 1L));
            batch.put(key, tx.toByteArray());
            batch.put(LATEST_TXID, Longs.toByteArray((long)(this.lastTxID + 1L)));
            this.deletedStore.writeBatch(batch);
            ++this.lastTxID;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getNumOfValidTransactions() throws IOException {
        this.lock.lock();
        try {
            AtomicInteger num = new AtomicInteger(0);
            this.deletedStore.iterate(null, (key, value) -> {
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX;
                if (!Arrays.equals(LATEST_TXID, key) && (delTX = StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.parseFrom((byte[])value)).getCount() > -1) {
                    num.incrementAndGet();
                }
                return true;
            });
            int n = num.get();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactions(Map<Long, List<Long>> containerBlocksMap) throws IOException {
        BatchOperation batch = new BatchOperation();
        this.lock.lock();
        try {
            long currentLatestID = this.lastTxID;
            for (Map.Entry<Long, List<Long>> entry : containerBlocksMap.entrySet()) {
                byte[] key = Longs.toByteArray((long)(++currentLatestID));
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx = this.constructNewTransaction(currentLatestID, entry.getKey(), entry.getValue());
                batch.put(key, tx.toByteArray());
            }
            this.lastTxID = currentLatestID;
            batch.put(LATEST_TXID, Longs.toByteArray((long)this.lastTxID));
            this.deletedStore.writeBatch(batch);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.deletedStore != null) {
            this.deletedStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, Long> getTransactions(DatanodeDeletedBlockTransactions transactions) throws IOException {
        this.lock.lock();
        try {
            HashMap<Long, Long> deleteTransactionMap = new HashMap<Long, Long>();
            this.deletedStore.iterate(null, (key, value) -> {
                if (!Arrays.equals(LATEST_TXID, key)) {
                    StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction block = StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.parseFrom((byte[])value);
                    if (block.getCount() > -1 && block.getCount() <= this.maxRetry && transactions.addTransaction(block, this.transactionToDNsCommitMap.get(block.getTxID()))) {
                        deleteTransactionMap.put(block.getContainerID(), block.getTxID());
                        this.transactionToDNsCommitMap.putIfAbsent(block.getTxID(), (Set<UUID>)new ConcurrentHashSet());
                    }
                    return !transactions.isFull();
                }
                return true;
            });
            HashMap<Long, Long> hashMap = deleteTransactionMap;
            return hashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onMessage(CommandStatusReportHandler.DeleteBlockStatus deleteBlockStatus, EventPublisher publisher) {
        StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto ackProto = deleteBlockStatus.getCmdStatus().getBlockDeletionAck();
        this.commitTransactions(ackProto.getResultsList(), UUID.fromString(ackProto.getDnId()));
    }
}

