/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.OzoneAcl;

public final class VolumeArgs {
    private final String admin;
    private final String owner;
    private final String quota;
    private final List<OzoneAcl> acls;

    private VolumeArgs(String admin, String owner, String quota, List<OzoneAcl> acls) {
        this.admin = admin;
        this.owner = owner;
        this.quota = quota;
        this.acls = acls;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getQuota() {
        return this.quota;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String adminName;
        private String ownerName;
        private String volumeQuota;
        private List<OzoneAcl> listOfAcls;

        public Builder setAdmin(String admin) {
            this.adminName = admin;
            return this;
        }

        public Builder setOwner(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setQuota(String quota) {
            this.volumeQuota = quota;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> acls) throws IOException {
            this.listOfAcls = acls;
            return this;
        }

        public VolumeArgs build() {
            return new VolumeArgs(this.adminName, this.ownerName, this.volumeQuota, this.listOfAcls);
        }
    }
}

