/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;

public class OzoneBucket {
    private final ClientProtocol proxy;
    private final String volumeName;
    private final String name;
    private final ReplicationFactor defaultReplication;
    private final ReplicationType defaultReplicationType;
    private List<OzoneAcl> acls;
    private StorageType storageType;
    private Boolean versioning;
    private int listCacheSize;
    private long creationTime;

    public OzoneBucket(Configuration conf, ClientProtocol proxy, String volumeName, String bucketName, List<OzoneAcl> acls, StorageType storageType, Boolean versioning, long creationTime) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Client proxy is not set.");
        this.proxy = proxy;
        this.volumeName = volumeName;
        this.name = bucketName;
        this.acls = acls;
        this.storageType = storageType;
        this.versioning = versioning;
        this.listCacheSize = HddsClientUtils.getListCacheSize((Configuration)conf);
        this.creationTime = creationTime;
        this.defaultReplication = ReplicationFactor.valueOf((int)conf.getInt("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT));
        this.defaultReplicationType = ReplicationType.valueOf((String)conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
    }

    @VisibleForTesting
    OzoneBucket(String volumeName, String name, ReplicationFactor defaultReplication, ReplicationType defaultReplicationType, List<OzoneAcl> acls, StorageType storageType, Boolean versioning, long creationTime) {
        this.proxy = null;
        this.volumeName = volumeName;
        this.name = name;
        this.defaultReplication = defaultReplication;
        this.defaultReplicationType = defaultReplicationType;
        this.acls = acls;
        this.storageType = storageType;
        this.versioning = versioning;
        this.creationTime = creationTime;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getName() {
        return this.name;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void addAcls(List<OzoneAcl> addAcls) throws IOException {
        this.proxy.addBucketAcls(this.volumeName, this.name, addAcls);
        addAcls.stream().filter(acl -> !this.acls.contains(acl)).forEach(this.acls::add);
    }

    public void removeAcls(List<OzoneAcl> removeAcls) throws IOException {
        this.proxy.removeBucketAcls(this.volumeName, this.name, removeAcls);
        this.acls.removeAll(removeAcls);
    }

    public void setStorageType(StorageType newStorageType) throws IOException {
        this.proxy.setBucketStorageType(this.volumeName, this.name, newStorageType);
        this.storageType = newStorageType;
    }

    public void setVersioning(Boolean newVersioning) throws IOException {
        this.proxy.setBucketVersioning(this.volumeName, this.name, newVersioning);
        this.versioning = newVersioning;
    }

    public OzoneOutputStream createKey(String key, long size) throws IOException {
        return this.createKey(key, size, this.defaultReplicationType, this.defaultReplication);
    }

    public OzoneOutputStream createKey(String key, long size, ReplicationType type, ReplicationFactor factor) throws IOException {
        return this.proxy.createKey(this.volumeName, this.name, key, size, type, factor);
    }

    public OzoneInputStream readKey(String key) throws IOException {
        return this.proxy.getKey(this.volumeName, this.name, key);
    }

    public OzoneKeyDetails getKey(String key) throws IOException {
        return this.proxy.getKeyDetails(this.volumeName, this.name, key);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix) {
        return this.listKeys(keyPrefix, null);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix, String prevKey) {
        return new KeyIterator(keyPrefix, prevKey);
    }

    public void deleteKey(String key) throws IOException {
        this.proxy.deleteKey(this.volumeName, this.name, key);
    }

    public void renameKey(String fromKeyName, String toKeyName) throws IOException {
        this.proxy.renameKey(this.volumeName, this.name, fromKeyName, toKeyName);
    }

    private class KeyIterator
    implements Iterator<OzoneKey> {
        private String keyPrefix = null;
        private Iterator<OzoneKey> currentIterator;
        private OzoneKey currentValue;

        KeyIterator(String keyPrefix, String prevKey) {
            this.keyPrefix = keyPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfKeys(prevKey).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = this.getNextListOfKeys(this.currentValue != null ? this.currentValue.getName() : null).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneKey next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneKey> getNextListOfKeys(String prevKey) {
            try {
                return OzoneBucket.this.proxy.listKeys(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.keyPrefix, prevKey, OzoneBucket.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

