/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.security.UserGroupInformation;

public class ObjectStore {
    private final ClientProtocol proxy;
    private int listCacheSize;

    public ObjectStore(Configuration conf, ClientProtocol proxy) {
        this.proxy = proxy;
        this.listCacheSize = HddsClientUtils.getListCacheSize((Configuration)conf);
    }

    @VisibleForTesting
    protected ObjectStore() {
        this.proxy = null;
    }

    public void createVolume(String volumeName) throws IOException {
        this.proxy.createVolume(volumeName);
    }

    public void createVolume(String volumeName, VolumeArgs volumeArgs) throws IOException {
        this.proxy.createVolume(volumeName, volumeArgs);
    }

    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        this.proxy.createS3Bucket(userName, s3BucketName);
    }

    public void deleteS3Bucket(String bucketName) throws IOException {
        this.proxy.deleteS3Bucket(bucketName);
    }

    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        return this.proxy.getOzoneBucketMapping(s3BucketName);
    }

    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[0];
    }

    public String getOzoneBucketName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[1];
    }

    public OzoneVolume getVolume(String volumeName) throws IOException {
        OzoneVolume volume = this.proxy.getVolumeDetails(volumeName);
        return volume;
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix) throws IOException {
        return this.listVolumes(volumePrefix, null);
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix, String prevVolume) throws IOException {
        return new VolumeIterator(null, volumePrefix, prevVolume);
    }

    public Iterator<? extends OzoneVolume> listVolumesByUser(String user, String volumePrefix, String prevVolume) throws IOException {
        if (Strings.isNullOrEmpty((String)user)) {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        return new VolumeIterator(user, volumePrefix, prevVolume);
    }

    public void deleteVolume(String volumeName) throws IOException {
        this.proxy.deleteVolume(volumeName);
    }

    private class VolumeIterator
    implements Iterator<OzoneVolume> {
        private String user = null;
        private String volPrefix = null;
        private Iterator<OzoneVolume> currentIterator;
        private OzoneVolume currentValue;

        VolumeIterator(String user, String volPrefix, String prevVolume) {
            this.user = user;
            this.volPrefix = volPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfVolumes(prevVolume).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = this.getNextListOfVolumes(this.currentValue != null ? this.currentValue.getName() : null).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneVolume next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneVolume> getNextListOfVolumes(String prevVolume) {
            try {
                if (this.user != null) {
                    return ObjectStore.this.proxy.listVolumes(this.user, this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
                }
                return ObjectStore.this.proxy.listVolumes(this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

