/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftClientProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SlidingWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientProtocolService
extends RaftClientProtocolServiceGrpc.RaftClientProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcClientProtocolService.class);
    private static final PendingAppend COMPLETED = new PendingAppend(null);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftClientAsynchronousProtocol protocol;
    private final AtomicInteger streamCount = new AtomicInteger();

    public GrpcClientProtocolService(Supplier<RaftPeerId> idSupplier, RaftClientAsynchronousProtocol protocol) {
        this.idSupplier = idSupplier;
        this.protocol = protocol;
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    public void setConfiguration(RaftProtos.SetConfigurationRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.setConfigurationAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    public StreamObserver<RaftProtos.RaftClientRequestProto> append(StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        return new AppendRequestStreamObserver(responseObserver);
    }

    private class AppendRequestStreamObserver
    implements StreamObserver<RaftProtos.RaftClientRequestProto> {
        private final String name;
        private final StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver;
        private final SlidingWindow.Server<PendingAppend, RaftClientReply> slidingWindow;
        private final AtomicBoolean isClosed;

        AppendRequestStreamObserver(StreamObserver<RaftProtos.RaftClientReplyProto> ro) {
            this.name = GrpcClientProtocolService.this.getId() + "-" + GrpcClientProtocolService.this.streamCount.getAndIncrement();
            this.slidingWindow = new SlidingWindow.Server((Object)this.name, (SlidingWindow.Request)COMPLETED);
            LOG.debug("new AppendRequestStreamObserver {}", (Object)this.name);
            this.responseObserver = ro;
            this.isClosed = new AtomicBoolean(false);
        }

        void processClientRequestAsync(PendingAppend pending) {
            try {
                ((CompletableFuture)GrpcClientProtocolService.this.protocol.submitClientRequestAsync(pending.getRequest()).thenAcceptAsync(reply -> this.slidingWindow.receiveReply(pending.getSeqNum(), reply, this::sendReply, this::processClientRequestAsync))).exceptionally(exception -> {
                    this.responseError((Throwable)exception, () -> "processClientRequestAsync for " + pending.getRequest());
                    return null;
                });
            }
            catch (IOException e) {
                throw new CompletionException("Failed processClientRequestAsync for " + pending.getRequest(), e);
            }
        }

        public void onNext(RaftProtos.RaftClientRequestProto request) {
            try {
                RaftClientRequest r = ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)request);
                PendingAppend p = new PendingAppend(r);
                this.slidingWindow.receivedRequest((SlidingWindow.Request)p, this::processClientRequestAsync);
            }
            catch (Throwable e) {
                this.responseError(e, () -> "onNext for " + ClientProtoUtils.toString((RaftProtos.RaftClientRequestProto)request));
            }
        }

        private void sendReply(PendingAppend ready) {
            Preconditions.assertTrue((boolean)ready.hasReply());
            if (ready == COMPLETED) {
                this.close();
            } else {
                LOG.debug("{}: sendReply seq={}, {}", new Object[]{this.name, ready.getSeqNum(), ready.getReply()});
                this.responseObserver.onNext((Object)ClientProtoUtils.toRaftClientReplyProto((RaftClientReply)ready.getReply()));
            }
        }

        public void onError(Throwable t) {
            GrpcUtil.warn(LOG, () -> this.name + ": onError", t);
            this.slidingWindow.close();
        }

        public void onCompleted() {
            if (this.slidingWindow.endOfRequests()) {
                this.close();
            }
        }

        private void close() {
            if (this.isClosed.compareAndSet(false, true)) {
                LOG.debug("{}: close", (Object)this.name);
                this.responseObserver.onCompleted();
                this.slidingWindow.close();
            }
        }

        void responseError(Throwable t, Supplier<String> message) {
            if (this.isClosed.compareAndSet(false, true)) {
                t = JavaUtils.unwrapCompletionException((Throwable)t);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.name + ": Failed " + message.get(), t);
                }
                this.responseObserver.onError((Throwable)GrpcUtil.wrapException(t));
                this.slidingWindow.close();
            }
        }
    }

    private static class PendingAppend
    implements SlidingWindow.Request<RaftClientReply> {
        private final RaftClientRequest request;
        private volatile RaftClientReply reply;

        PendingAppend(RaftClientRequest request) {
            this.request = request;
        }

        public boolean hasReply() {
            return this.reply != null || this == COMPLETED;
        }

        public void setReply(RaftClientReply reply) {
            this.reply = reply;
        }

        RaftClientReply getReply() {
            return this.reply;
        }

        RaftClientRequest getRequest() {
            return this.request;
        }

        public long getSeqNum() {
            return this.request != null ? this.request.getSeqNum() : Long.MAX_VALUE;
        }

        public String toString() {
            return this.request != null ? this.getSeqNum() + ":" + this.reply : "COMPLETED";
        }
    }
}

