/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.ServerNotReadyException;
import org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.CheckedSupplier;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;

public interface GrpcUtil {
    public static final Metadata.Key<String> EXCEPTION_TYPE_KEY = Metadata.Key.of((String)"exception-type", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> CALL_ID = Metadata.Key.of((String)"call-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static StatusRuntimeException wrapException(Throwable t) {
        return GrpcUtil.wrapException(t, -1L);
    }

    public static StatusRuntimeException wrapException(Throwable t, long callId) {
        t = JavaUtils.unwrapCompletionException((Throwable)t);
        Metadata trailers = new Metadata();
        trailers.put(EXCEPTION_TYPE_KEY, (Object)t.getClass().getCanonicalName());
        if (callId > 0L) {
            trailers.put(CALL_ID, (Object)String.valueOf(callId));
        }
        return new StatusRuntimeException(Status.INTERNAL.withCause(t).withDescription(t.getMessage()), trailers);
    }

    public static Throwable unwrapThrowable(Throwable t) {
        IOException ioe;
        if (t instanceof StatusRuntimeException && (ioe = GrpcUtil.tryUnwrapException((StatusRuntimeException)t)) != null) {
            return ioe;
        }
        return t;
    }

    public static IOException unwrapException(StatusRuntimeException se) {
        IOException ioe = GrpcUtil.tryUnwrapException(se);
        return ioe != null ? ioe : new IOException((Throwable)se);
    }

    public static IOException tryUnwrapException(StatusRuntimeException se) {
        String className;
        Metadata trailers = se.getTrailers();
        Status status = se.getStatus();
        if (trailers != null && status != null && (className = (String)trailers.get(EXCEPTION_TYPE_KEY)) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                Exception unwrapped = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), (String)status.getDescription(), (Exception)se);
                return IOUtils.asIOException((Throwable)unwrapped);
            }
            catch (Exception e) {
                se.addSuppressed((Throwable)e);
                return new IOException((Throwable)se);
            }
        }
        return null;
    }

    public static long getCallId(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            Metadata trailers = ((StatusRuntimeException)t).getTrailers();
            String callId = (String)trailers.get(CALL_ID);
            return callId != null ? (long)Integer.parseInt(callId) : -1L;
        }
        return -1L;
    }

    public static IOException unwrapIOException(Throwable t) {
        IOException e = t instanceof StatusRuntimeException ? GrpcUtil.unwrapException((StatusRuntimeException)t) : IOUtils.asIOException((Throwable)t);
        return e;
    }

    public static <REPLY extends RaftClientReply, REPLY_PROTO> void asyncCall(StreamObserver<REPLY_PROTO> responseObserver, CheckedSupplier<CompletableFuture<REPLY>, IOException> supplier, Function<REPLY, REPLY_PROTO> toProto) {
        try {
            ((CompletableFuture)supplier.get()).whenCompleteAsync((reply, exception) -> {
                if (exception != null) {
                    responseObserver.onError((Throwable)GrpcUtil.wrapException(exception));
                } else {
                    responseObserver.onNext(toProto.apply(reply));
                    responseObserver.onCompleted();
                }
            });
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t) {
        LogUtils.warn((Logger)log, message, (Throwable)GrpcUtil.unwrapThrowable(t), (Class[])new Class[]{StatusRuntimeException.class, ServerNotReadyException.class});
    }
}

