/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;

public class Credential {
    private String accessKeyID;
    private String date;
    private String awsRegion;
    private String awsService;
    private String awsRequest;
    private String credential;

    Credential(String cred) throws OS3Exception {
        this.credential = cred;
        this.parseCredential();
    }

    public void parseCredential() throws OS3Exception {
        String[] split = this.credential.split("/");
        if (split.length != 5) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.credential);
        }
        this.accessKeyID = split[0];
        this.date = split[1];
        this.awsRegion = split[2];
        this.awsService = split[3];
        this.awsRequest = split[4];
    }

    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public String getDate() {
        return this.date;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getAwsService() {
        return this.awsService;
    }

    public String getAwsRequest() {
        return this.awsRequest;
    }

    public String getCredential() {
        return this.credential;
    }
}

