/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.header.Credential;

public class AuthorizationHeaderV4 {
    private static final String CREDENTIAL = "Credential=";
    private static final String SIGNEDHEADERS = "SignedHeaders=";
    private static final String SIGNATURE = "Signature=";
    private String authHeader;
    private String algorithm;
    private String credential;
    private String signedHeaders;
    private String signature;
    private Credential credentialObj;

    public AuthorizationHeaderV4(String header) throws OS3Exception {
        Preconditions.checkNotNull((Object)header);
        this.authHeader = header;
        this.parseAuthHeader();
    }

    public void parseAuthHeader() throws OS3Exception {
        String[] split = this.authHeader.split(" ");
        if (split.length != 4) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.algorithm = split[0];
        this.credential = split[1];
        this.signedHeaders = split[2];
        this.signature = split[3];
        if (!this.credential.startsWith(CREDENTIAL)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.credential = this.credential.substring(CREDENTIAL.length(), this.credential.length() - 1);
        if (!this.signedHeaders.startsWith(SIGNEDHEADERS)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.signedHeaders = this.signedHeaders.substring(SIGNEDHEADERS.length(), this.signedHeaders.length() - 1);
        if (!this.signature.startsWith(SIGNATURE)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.signature = this.signature.substring(SIGNATURE.length(), this.signature.length());
        this.credentialObj = new Credential(this.credential);
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getSignedHeaders() {
        return this.signedHeaders;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getAccessKeyID() {
        return this.credentialObj.getAccessKeyID();
    }

    public String getDate() {
        return this.credentialObj.getDate();
    }

    public String getAwsRegion() {
        return this.credentialObj.getAwsRegion();
    }

    public String getAwsService() {
        return this.credentialObj.getAwsService();
    }

    public String getAwsRequest() {
        return this.credentialObj.getAwsRequest();
    }
}

