/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;

public class AuthorizationHeaderV2 {
    private static final String IDENTIFIER = "AWS";
    private String authHeader;
    private String identifier;
    private String accessKeyID;
    private String signature;

    public AuthorizationHeaderV2(String auth) throws OS3Exception {
        Preconditions.checkNotNull((Object)auth);
        this.authHeader = auth;
        this.parseHeader();
    }

    public void parseHeader() throws OS3Exception {
        String[] split = this.authHeader.split(" ");
        if (split.length != 2) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.identifier = split[0];
        if (!IDENTIFIER.equals(this.identifier)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        String[] remainingSplit = split[1].split(":");
        if (remainingSplit.length != 2) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
        this.accessKeyID = remainingSplit[0];
        this.signature = remainingSplit[1];
        if (StringUtils.isBlank((CharSequence)this.accessKeyID) || StringUtils.isBlank((CharSequence)this.signature)) {
            throw S3ErrorTable.newError(S3ErrorTable.MALFORMED_HEADER, this.authHeader);
        }
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    public void setAuthHeader(String authHeader) {
        this.authHeader = authHeader;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public String getSignature() {
        return this.signature;
    }
}

