/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import javax.enterprise.context.RequestScoped;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV2;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class AuthenticationHeaderParser {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationHeaderParser.class);
    private String authHeader;
    private String accessKeyID;

    public void parse() throws OS3Exception {
        if (this.authHeader.startsWith("AWS4")) {
            LOG.debug("V4 Header {}", (Object)this.authHeader);
            AuthorizationHeaderV4 authorizationHeader = new AuthorizationHeaderV4(this.authHeader);
            this.accessKeyID = authorizationHeader.getAccessKeyID().toLowerCase();
        } else {
            LOG.debug("V2 Header {}", (Object)this.authHeader);
            AuthorizationHeaderV2 authorizationHeader = new AuthorizationHeaderV2(this.authHeader);
            this.accessKeyID = authorizationHeader.getAccessKeyID().toLowerCase();
        }
    }

    public String getAccessKeyID() throws OS3Exception {
        this.parse();
        return this.accessKeyID;
    }

    public void setAuthHeader(String header) {
        this.authHeader = header;
    }
}

