/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.exception;

import org.apache.hadoop.ozone.s3.exception.OS3Exception;

public final class S3ErrorTable {
    public static final OS3Exception INVALID_URI = new OS3Exception("InvalidURI", "Couldn't parse the specified URI.", 400);
    public static final OS3Exception NO_SUCH_VOLUME = new OS3Exception("NoSuchVolume", "The specified volume does not exist", 404);
    public static final OS3Exception NO_SUCH_BUCKET = new OS3Exception("NoSuchBucket", "The specified bucket does not exist", 404);
    public static final OS3Exception BUCKET_NOT_EMPTY = new OS3Exception("BucketNotEmpty", "The bucket you tried to delete is not empty.", 409);
    public static final OS3Exception MALFORMED_HEADER = new OS3Exception("AuthorizationHeaderMalformed", "The authorization header you provided is invalid.", 404);
    public static final OS3Exception NO_SUCH_KEY = new OS3Exception("NoSuchKey", "The specified key does not exist", 404);
    public static final OS3Exception INVALID_ARGUMENT = new OS3Exception("InvalidArgument", "Invalid Argument", 400);
    public static final OS3Exception INVALID_REQUEST = new OS3Exception("InvalidRequest", "Invalid Request", 400);

    private S3ErrorTable() {
    }

    public static OS3Exception newError(OS3Exception e, String resource) {
        OS3Exception err = new OS3Exception(e.getCode(), e.getErrorMessage(), e.getHttpCode());
        err.setResource(resource);
        return err;
    }
}

