/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.s3.commontypes.BucketMetadata;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListBucketResponse;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RootEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(RootEndpoint.class);

    @GET
    public ListBucketResponse get() throws OS3Exception, IOException {
        OzoneVolume volume;
        ListBucketResponse response = new ListBucketResponse();
        String volumeName = "s3" + this.getAuthenticationHeaderParser().getAccessKeyID();
        try {
            volume = this.getVolume(volumeName);
        }
        catch (NotFoundException ex) {
            return response;
        }
        catch (IOException e) {
            throw e;
        }
        Iterator volABucketIter = volume.listBuckets(null);
        while (volABucketIter.hasNext()) {
            OzoneBucket next = (OzoneBucket)volABucketIter.next();
            BucketMetadata bucketMetadata = new BucketMetadata();
            bucketMetadata.setName(next.getName());
            bucketMetadata.setCreationDate(Instant.ofEpochMilli(next.getCreationTime()));
            response.addBucket(bucketMetadata);
        }
        return response;
    }
}

