/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.s3.SignedChunksInputStream;
import org.apache.hadoop.ozone.s3.endpoint.CopyObjectResponse;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.S3StorageType;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{bucket}/{path:.+}")
public class ObjectEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectEndpoint.class);
    @Context
    private HttpHeaders headers;
    private List<String> customizableGetHeaders = new ArrayList<String>();

    public ObjectEndpoint() {
        this.customizableGetHeaders.add("Content-Type");
        this.customizableGetHeaders.add("Content-Language");
        this.customizableGetHeaders.add("Expires");
        this.customizableGetHeaders.add("Cache-Control");
        this.customizableGetHeaders.add("Content-Disposition");
        this.customizableGetHeaders.add("Content-Encoding");
    }

    @PUT
    public Response put(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @HeaderParam(value="Content-Length") long length, InputStream body) throws IOException, OS3Exception {
        try (OzoneOutputStream output = null;){
            boolean storageTypeDefault;
            ReplicationFactor replicationFactor;
            ReplicationType replicationType;
            String copyHeader = this.headers.getHeaderString("x-amz-copy-source");
            String storageType = this.headers.getHeaderString("x-amz-storage-class");
            if (storageType == null) {
                replicationType = S3StorageType.getDefault().getType();
                replicationFactor = S3StorageType.getDefault().getFactor();
                storageTypeDefault = true;
            } else {
                try {
                    replicationType = S3StorageType.valueOf(storageType).getType();
                    replicationFactor = S3StorageType.valueOf(storageType).getFactor();
                }
                catch (IllegalArgumentException ex) {
                    throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, storageType);
                }
                storageTypeDefault = false;
            }
            if (copyHeader != null) {
                CopyObjectResponse copyObjectResponse = this.copyObject(copyHeader, bucketName, keyPath, replicationType, replicationFactor, storageTypeDefault);
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)copyObjectResponse).header("Connection", (Object)"close").build();
                return response;
            }
            OzoneBucket bucket = this.getBucket(bucketName);
            output = bucket.createKey(keyPath, length, replicationType, replicationFactor);
            if ("STREAMING-AWS4-HMAC-SHA256-PAYLOAD".equals(this.headers.getHeaderString("x-amz-content-sha256"))) {
                body = new SignedChunksInputStream(body);
            }
            IOUtils.copy((InputStream)body, (OutputStream)output);
            Response response = Response.ok().status(200).build();
            return response;
        }
    }

    @GET
    public Response get(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, InputStream body) throws IOException, OS3Exception {
        try {
            OzoneBucket bucket = this.getBucket(bucketName);
            OzoneInputStream key = bucket.readKey(keyPath);
            StreamingOutput output = dest -> IOUtils.copy((InputStream)key, (OutputStream)dest);
            Response.ResponseBuilder responseBuilder = Response.ok((Object)output);
            for (String responseHeader : this.customizableGetHeaders) {
                String headerValue = this.headers.getHeaderString(responseHeader);
                if (headerValue == null) continue;
                responseBuilder.header(responseHeader, (Object)headerValue);
            }
            return responseBuilder.build();
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("NOT_FOUND")) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, keyPath);
                throw os3Exception;
            }
            throw ex;
        }
    }

    @HEAD
    public Response head(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath) throws Exception {
        OzoneKeyDetails key;
        try {
            key = this.getBucket(bucketName).getKey(keyPath);
        }
        catch (IOException ex) {
            LOG.error("Exception occurred in HeadObject", (Throwable)ex);
            if (ex.getMessage().contains("KEY_NOT_FOUND")) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw ex;
        }
        ZonedDateTime lastModificationTime = Instant.ofEpochMilli(key.getModificationTime()).atZone(ZoneId.of("GMT"));
        return Response.ok().status(200).header("Last-Modified", (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format(lastModificationTime)).header("ETag", (Object)("" + key.getModificationTime())).header("Content-Length", (Object)key.getDataSize()).header("Content-Type", (Object)"binary/octet-stream").build();
    }

    @DELETE
    public Response delete(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath) throws IOException, OS3Exception {
        block3: {
            try {
                OzoneBucket bucket = this.getBucket(bucketName);
                bucket.getKey(keyPath);
                bucket.deleteKey(keyPath);
            }
            catch (IOException ex) {
                if (ex.getMessage().contains("BUCKET_NOT_FOUND")) {
                    throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
                }
                if (ex.getMessage().contains("NOT_FOUND")) break block3;
                throw ex;
            }
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @VisibleForTesting
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    private CopyObjectResponse copyObject(String copyHeader, String destBucket, String destkey, ReplicationType replicationType, ReplicationFactor replicationFactor, boolean storageTypeDefault) throws OS3Exception, IOException {
        int pos;
        if (copyHeader.startsWith("/")) {
            copyHeader = copyHeader.substring(1);
        }
        if ((pos = copyHeader.indexOf("/")) == -1) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, copyHeader);
            ex.setErrorMessage("Copy Source must mention the source bucket and key: sourcebucket/sourcekey");
            throw ex;
        }
        String sourceBucket = copyHeader.substring(0, pos);
        String sourceKey = copyHeader.substring(pos + 1);
        OzoneInputStream sourceInputStream = null;
        OzoneOutputStream destOutputStream = null;
        boolean closed = false;
        try {
            if (sourceBucket.equals(destBucket) && sourceKey.equals(destkey)) {
                if (storageTypeDefault) {
                    OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, copyHeader);
                    ex.setErrorMessage("This copy request is illegal because it is trying to copy an object to it self itself without changing the object's metadata, storage class, website redirect location or encryption attributes.");
                    throw ex;
                }
                CopyObjectResponse copyObjectResponse = new CopyObjectResponse();
                copyObjectResponse.setETag(OzoneUtils.getRequestID());
                copyObjectResponse.setLastModified(Instant.ofEpochMilli(Time.now()));
                CopyObjectResponse copyObjectResponse2 = copyObjectResponse;
                return copyObjectResponse2;
            }
            OzoneBucket sourceOzoneBucket = this.getBucket(sourceBucket);
            OzoneBucket destOzoneBucket = this.getBucket(destBucket);
            OzoneKeyDetails sourceKeyDetails = sourceOzoneBucket.getKey(sourceKey);
            long sourceKeyLen = sourceKeyDetails.getDataSize();
            sourceInputStream = sourceOzoneBucket.readKey(sourceKey);
            destOutputStream = destOzoneBucket.createKey(destkey, sourceKeyLen, replicationType, replicationFactor);
            IOUtils.copy((InputStream)sourceInputStream, (OutputStream)destOutputStream);
            sourceInputStream.close();
            destOutputStream.close();
            closed = true;
            OzoneKeyDetails destKeyDetails = destOzoneBucket.getKey(destkey);
            CopyObjectResponse copyObjectResponse = new CopyObjectResponse();
            copyObjectResponse.setETag(OzoneUtils.getRequestID());
            copyObjectResponse.setLastModified(Instant.ofEpochMilli(destKeyDetails.getModificationTime()));
            CopyObjectResponse copyObjectResponse3 = copyObjectResponse;
            return copyObjectResponse3;
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("KEY_NOT_FOUND")) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, sourceKey);
            }
            LOG.error("Exception occurred in PutObject", (Throwable)ex);
            throw ex;
        }
        finally {
            if (!closed) {
                if (sourceInputStream != null) {
                    sourceInputStream.close();
                }
                if (destOutputStream != null) {
                    destOutputStream.close();
                }
            }
        }
    }
}

