/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.header.AuthenticationHeaderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointBase.class);
    @Inject
    private OzoneClient client;
    @Inject
    private AuthenticationHeaderParser authenticationHeaderParser;

    protected OzoneBucket getBucket(String volumeName, String bucketName) throws IOException {
        return this.getVolume(volumeName).getBucket(bucketName);
    }

    protected OzoneBucket getBucket(OzoneVolume volume, String bucketName) throws OS3Exception, IOException {
        OzoneBucket bucket;
        try {
            bucket = volume.getBucket(bucketName);
        }
        catch (IOException ex) {
            LOG.error("Error occurred is {}", (Throwable)ex);
            if (ex.getMessage().contains("NOT_FOUND")) {
                OS3Exception oex = S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
                throw oex;
            }
            throw ex;
        }
        return bucket;
    }

    protected OzoneBucket getBucket(String bucketName) throws OS3Exception, IOException {
        OzoneBucket bucket;
        try {
            OzoneVolume volume = this.getVolume(this.getOzoneVolumeName(bucketName));
            bucket = volume.getBucket(bucketName);
        }
        catch (IOException ex) {
            LOG.error("Error occurred is {}", (Throwable)ex);
            if (ex.getMessage().contains("NOT_FOUND")) {
                OS3Exception oex = S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
                throw oex;
            }
            throw ex;
        }
        return bucket;
    }

    protected OzoneVolume getVolume(String volumeName) throws IOException {
        OzoneVolume volume = null;
        try {
            volume = this.client.getObjectStore().getVolume(volumeName);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("NOT_FOUND")) {
                throw new NotFoundException("Volume " + volumeName + " is not found");
            }
            throw ex;
        }
        return volume;
    }

    protected String createS3Bucket(String userName, String bucketName) throws IOException {
        block2: {
            try {
                this.client.getObjectStore().createS3Bucket(userName, bucketName);
            }
            catch (IOException ex) {
                LOG.error("createS3Bucket error:", (Throwable)ex);
                if (ex.getMessage().contains("ALREADY_EXISTS")) break block2;
                throw ex;
            }
        }
        String location = this.client.getObjectStore().getOzoneBucketName(bucketName);
        return "/" + location;
    }

    public void deleteS3Bucket(String s3BucketName) throws IOException {
        this.client.getObjectStore().deleteS3Bucket(s3BucketName);
    }

    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        return this.client.getObjectStore().getOzoneBucketMapping(s3BucketName);
    }

    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        return this.client.getObjectStore().getOzoneVolumeName(s3BucketName);
    }

    public String getOzoneBucketName(String s3BucketName) throws IOException {
        return this.client.getObjectStore().getOzoneBucketName(s3BucketName);
    }

    public AuthenticationHeaderParser getAuthenticationHeaderParser() {
        return this.authenticationHeaderParser;
    }

    @VisibleForTesting
    public void setAuthenticationHeaderParser(AuthenticationHeaderParser parser) {
        this.authenticationHeaderParser = parser;
    }

    @VisibleForTesting
    public void setClient(OzoneClient ozoneClient) {
        this.client = ozoneClient;
    }
}

