/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Iterator;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.s3.commontypes.KeyMetadata;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListObjectResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteRequest;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteResponse;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.S3StorageType;
import org.apache.hadoop.ozone.s3.util.S3utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{bucket}")
public class BucketEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(BucketEndpoint.class);

    @GET
    @SuppressFBWarnings
    public Response list(@PathParam(value="bucket") String bucketName, @QueryParam(value="delimiter") String delimiter, @QueryParam(value="encoding-type") String encodingType, @QueryParam(value="marker") String marker, @DefaultValue(value="1000") @QueryParam(value="max-keys") int maxKeys, @QueryParam(value="prefix") String prefix, @QueryParam(value="browser") String browser, @QueryParam(value="continuation-token") String continueToken, @QueryParam(value="start-after") String startAfter, @Context HttpHeaders hh) throws OS3Exception, IOException {
        if (browser != null) {
            InputStream browserPage = this.getClass().getResourceAsStream("/browser.html");
            return Response.ok((Object)browserPage, (MediaType)MediaType.TEXT_HTML_TYPE).build();
        }
        if (prefix == null) {
            prefix = "";
        }
        OzoneBucket bucket = this.getBucket(bucketName);
        String decodedToken = S3utils.decodeContinueToken(continueToken);
        Iterator ozoneKeyIterator = startAfter != null && continueToken != null ? bucket.listKeys(prefix, decodedToken) : (startAfter != null && continueToken == null ? bucket.listKeys(prefix, startAfter) : (startAfter == null && continueToken != null ? bucket.listKeys(prefix, decodedToken) : bucket.listKeys(prefix)));
        ListObjectResponse response = new ListObjectResponse();
        response.setDelimiter(delimiter);
        response.setName(bucketName);
        response.setPrefix(prefix);
        response.setMarker("");
        response.setMaxKeys(maxKeys);
        response.setEncodingType("url");
        response.setTruncated(false);
        response.setContinueToken(continueToken);
        String prevDir = null;
        String lastKey = null;
        int count = 0;
        while (ozoneKeyIterator.hasNext()) {
            OzoneKey next = (OzoneKey)ozoneKeyIterator.next();
            String relativeKeyName = next.getName().substring(prefix.length());
            int depth = StringUtils.countMatches((CharSequence)relativeKeyName, (CharSequence)delimiter);
            if (delimiter != null) {
                if (depth > 0) {
                    String dirName = relativeKeyName.substring(0, relativeKeyName.indexOf(delimiter));
                    if (!dirName.equals(prevDir)) {
                        response.addPrefix(prefix + dirName + delimiter);
                        prevDir = dirName;
                        ++count;
                    }
                } else if (relativeKeyName.endsWith(delimiter)) {
                    response.addPrefix(relativeKeyName);
                    ++count;
                } else {
                    this.addKey(response, next);
                    ++count;
                }
            } else {
                this.addKey(response, next);
                ++count;
            }
            if (count != maxKeys) continue;
            lastKey = next.getName();
            break;
        }
        response.setKeyCount(count);
        if (count < maxKeys) {
            response.setTruncated(false);
        } else if (ozoneKeyIterator.hasNext()) {
            response.setTruncated(true);
            response.setNextToken(S3utils.generateContinueToken(lastKey));
        } else {
            response.setTruncated(false);
        }
        response.setKeyCount(response.getCommonPrefixes().size() + response.getContents().size());
        return Response.ok((Object)response).build();
    }

    @PUT
    public Response put(@PathParam(value="bucket") String bucketName, @Context HttpHeaders httpHeaders) throws IOException, OS3Exception {
        String userName = this.getAuthenticationHeaderParser().getAccessKeyID();
        String location = this.createS3Bucket(userName, bucketName);
        LOG.info("Location is {}", (Object)location);
        return Response.status((int)200).header("Location", (Object)location).build();
    }

    @HEAD
    public Response head(@PathParam(value="bucket") String bucketName) throws OS3Exception, IOException {
        try {
            this.getBucket(bucketName);
        }
        catch (OS3Exception ex) {
            LOG.error("Exception occurred in headBucket", (Throwable)ex);
            if (ex.getCode().contains("NoSuchBucket")) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            throw ex;
        }
        return Response.ok().build();
    }

    @DELETE
    public Response delete(@PathParam(value="bucket") String bucketName) throws IOException, OS3Exception {
        try {
            this.deleteS3Bucket(bucketName);
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("BUCKET_NOT_EMPTY")) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.BUCKET_NOT_EMPTY, bucketName);
                throw os3Exception;
            }
            if (ex.getMessage().contains("BUCKET_NOT_FOUND")) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
                throw os3Exception;
            }
            throw ex;
        }
        return Response.status((int)204).build();
    }

    @POST
    @Produces(value={"application/xml"})
    public MultiDeleteResponse multiDelete(@PathParam(value="bucket") String bucketName, @QueryParam(value="delete") String delete, MultiDeleteRequest request) throws OS3Exception, IOException {
        OzoneBucket bucket = this.getBucket(bucketName);
        MultiDeleteResponse result = new MultiDeleteResponse();
        if (request.getObjects() != null) {
            for (MultiDeleteRequest.DeleteObject keyToDelete : request.getObjects()) {
                try {
                    bucket.deleteKey(keyToDelete.getKey());
                    if (request.isQuiet()) continue;
                    result.addDeleted(new MultiDeleteResponse.DeletedObject(keyToDelete.getKey()));
                }
                catch (IOException ex) {
                    if (!ex.getMessage().contains("KEY_NOT_FOUND")) {
                        result.addError(new MultiDeleteResponse.Error(keyToDelete.getKey(), "InternalError", ex.getMessage()));
                        continue;
                    }
                    if (request.isQuiet()) continue;
                    result.addDeleted(new MultiDeleteResponse.DeletedObject(keyToDelete.getKey()));
                }
                catch (Exception ex) {
                    result.addError(new MultiDeleteResponse.Error(keyToDelete.getKey(), "InternalError", ex.getMessage()));
                }
            }
        }
        return result;
    }

    private void addKey(ListObjectResponse response, OzoneKey next) {
        KeyMetadata keyMetadata = new KeyMetadata();
        keyMetadata.setKey(next.getName());
        keyMetadata.setSize(next.getDataSize());
        keyMetadata.setETag("" + next.getModificationTime());
        if (next.getReplicationType().toString().equals(ReplicationType.STAND_ALONE.toString())) {
            keyMetadata.setStorageClass(S3StorageType.REDUCED_REDUNDANCY.toString());
        } else {
            keyMetadata.setStorageClass(S3StorageType.STANDARD.toString());
        }
        keyMetadata.setLastModified(Instant.ofEpochMilli(next.getModificationTime()));
        response.addKey(keyMetadata);
    }
}

