/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.s3.header.AuthenticationHeaderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class VirtualHostStyleFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualHostStyleFilter.class);
    @Inject
    private OzoneConfiguration conf;
    @Inject
    private AuthenticationHeaderParser authenticationHeaderParser;
    private String[] domains;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.authenticationHeaderParser.setAuthHeader(requestContext.getHeaderString("Authorization"));
        this.domains = this.conf.getTrimmedStrings("ozone.s3g.domain.name");
        if (this.domains.length == 0) {
            return;
        }
        String host = requestContext.getHeaderString("Host");
        String domain = this.getDomainName(host = this.checkHostWithoutPort(host));
        if (domain == null) {
            throw this.getException("Invalid S3 Gateway request {" + requestContext.getUriInfo().getRequestUri().toString() + " }: No matching domain {" + Arrays.toString(this.domains) + "} for the host {" + host + "}");
        }
        LOG.debug("Http header host name is {}", (Object)host);
        LOG.debug("Domain name matched is {}", (Object)domain);
        if (host.length() > domain.length()) {
            String bucketName = host.substring(0, host.length() - domain.length());
            if (!bucketName.endsWith(".")) {
                throw this.getException("Invalid S3 Gateway request {" + requestContext.getUriInfo().getRequestUri().toString() + "}: Host: {" + host + " is in invalid format");
            }
            bucketName = bucketName.substring(0, bucketName.length() - 1);
            LOG.debug("Bucket name is {}", (Object)bucketName);
            URI baseURI = requestContext.getUriInfo().getBaseUri();
            String currentPath = requestContext.getUriInfo().getPath();
            String newPath = bucketName;
            if (currentPath != null) {
                newPath = newPath + String.format("%s", currentPath);
            }
            MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
            UriBuilder requestAddrBuilder = UriBuilder.fromUri((URI)baseURI).path(newPath);
            queryParams.forEach((k, v) -> requestAddrBuilder.queryParam(k, v.toArray()));
            URI requestAddr = requestAddrBuilder.build(new Object[0]);
            requestContext.setRequestUri(baseURI, requestAddr);
        }
    }

    private InvalidRequestException getException(String message) {
        return new InvalidRequestException(message);
    }

    @VisibleForTesting
    public void setConfiguration(OzoneConfiguration config) {
        this.conf = config;
    }

    private String getDomainName(String host) {
        String match = null;
        int length = 0;
        for (String domainVal : this.domains) {
            int len;
            if (!host.endsWith(domainVal) || (len = domainVal.length()) <= length) continue;
            length = len;
            match = domainVal;
        }
        return match;
    }

    private String checkHostWithoutPort(String host) {
        if (host.contains(":")) {
            return host.substring(0, host.lastIndexOf(":"));
        }
        return host;
    }

    @VisibleForTesting
    public void setAuthenticationHeaderParser(AuthenticationHeaderParser parser) {
        this.authenticationHeaderParser = parser;
    }
}

