/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SignedChunksInputStream
extends InputStream {
    private Pattern signatureLinePattern = Pattern.compile("([0-9A-Fa-f]+);chunk-signature=.*");
    private InputStream originalStream;
    private int remainingData = 0;

    public SignedChunksInputStream(InputStream inputStream) {
        this.originalStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingData > 0) {
            int curr = this.originalStream.read();
            --this.remainingData;
            if (this.remainingData == 0) {
                this.originalStream.read();
                this.originalStream.read();
            }
            return curr;
        }
        this.remainingData = this.readHeader();
        if (this.remainingData == -1) {
            return -1;
        }
        return this.read();
    }

    private int readHeader() throws IOException {
        int prev = -1;
        int curr = 0;
        StringBuilder buf = new StringBuilder();
        while (!this.eol(prev, curr) && curr != -1) {
            int next = this.originalStream.read();
            if (next != -1) {
                buf.append((char)next);
            }
            prev = curr;
            curr = next;
        }
        String signatureLine = buf.toString().trim();
        if (signatureLine.length() == 0) {
            return -1;
        }
        Matcher matcher = this.signatureLinePattern.matcher(signatureLine);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1), 16);
        }
        throw new IOException("Invalid signature line: " + signatureLine);
    }

    private boolean eol(int prev, int curr) {
        return prev == 13 && curr == 10;
    }
}

