/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.s3.OzoneConfigurationHolder;
import org.apache.hadoop.ozone.s3.S3GatewayHttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone s3g", hidden=true, description={"S3 compatible rest server."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class Gateway
extends GenericCli {
    private static final Logger LOG = LoggerFactory.getLogger(Gateway.class);
    private S3GatewayHttpServer httpServer;

    public static void main(String[] args) throws Exception {
        new Gateway().run(args);
    }

    public Void call() throws Exception {
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        OzoneConfigurationHolder.setConfiguration(ozoneConfiguration);
        this.httpServer = new S3GatewayHttpServer((Configuration)ozoneConfiguration, "s3gateway");
        this.start();
        return null;
    }

    public void start() throws IOException {
        LOG.info("Starting Ozone S3 gateway");
        this.httpServer.start();
    }

    public void stop() throws Exception {
        LOG.info("Stopping Ozone S3 gateway");
        this.httpServer.stop();
    }
}

