/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.utils.db.TableIterator;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.WriteBatch;

@InterfaceStability.Evolving
public interface Table
extends AutoCloseable {
    public void put(byte[] var1, byte[] var2) throws IOException;

    public boolean isEmpty() throws IOException;

    public byte[] get(byte[] var1) throws IOException;

    public void delete(byte[] var1) throws IOException;

    public ColumnFamilyHandle getHandle();

    public void writeBatch(WriteBatch var1) throws IOException;

    public TableIterator<KeyValue> iterator();

    public String getName() throws IOException;

    public static class KeyValue {
        private final byte[] key;
        private final byte[] value;

        private KeyValue(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public static KeyValue create(byte[] key, byte[] value) {
            return new KeyValue(key, value);
        }

        public byte[] getKey() {
            byte[] result = new byte[this.key.length];
            System.arraycopy(this.key, 0, result, 0, this.key.length);
            return result;
        }

        public byte[] getValue() {
            byte[] result = new byte[this.value.length];
            System.arraycopy(this.value, 0, result, 0, this.value.length);
            return result;
        }
    }
}

