/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.utils.db.RDBStoreIterator;
import org.apache.hadoop.utils.db.Table;
import org.apache.hadoop.utils.db.TableIterator;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBTable
implements Table {
    private static final Logger LOG = LoggerFactory.getLogger(RDBTable.class);
    private final RocksDB db;
    private final ColumnFamilyHandle handle;
    private final WriteOptions writeOptions;

    public RDBTable(RocksDB db, ColumnFamilyHandle handle, WriteOptions writeOptions) {
        this.db = db;
        this.handle = handle;
        this.writeOptions = writeOptions;
    }

    public static IOException toIOException(String msg, RocksDBException e) {
        String statusCode = e.getStatus() == null ? "N/A" : e.getStatus().getCodeString();
        String errMessage = e.getMessage() == null ? "Unknown error" : e.getMessage();
        String output = msg + "; status : " + statusCode + "; message : " + errMessage;
        return new IOException(output, e);
    }

    @Override
    public ColumnFamilyHandle getHandle() {
        return this.handle;
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.db.put(this.handle, this.writeOptions, key, value);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to write to DB. Key: {}", (Object)new String(key, StandardCharsets.UTF_8));
            throw RDBTable.toIOException("Failed to put key-value to metadata store", e);
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (TableIterator<Table.KeyValue> keyIter = this.iterator();){
            keyIter.seekToFirst();
            boolean bl = !keyIter.hasNext();
            return bl;
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(this.handle, key);
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Failed to get the value for the given key", e);
        }
    }

    @Override
    public void delete(byte[] key) throws IOException {
        try {
            this.db.delete(this.handle, key);
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Failed to delete the given key", e);
        }
    }

    @Override
    public void writeBatch(WriteBatch operation) throws IOException {
        try {
            this.db.write(this.writeOptions, operation);
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Batch write operation failed", e);
        }
    }

    @Override
    public TableIterator<Table.KeyValue> iterator() {
        ReadOptions readOptions = new ReadOptions();
        return new RDBStoreIterator(this.db.newIterator(this.handle, readOptions));
    }

    @Override
    public String getName() throws IOException {
        try {
            return DFSUtil.bytes2String((byte[])this.getHandle().getName());
        }
        catch (RocksDBException rdbEx) {
            throw RDBTable.toIOException("Unable to get the table name.", rdbEx);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

