/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsConfigKeys;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.utils.db.DBConfigFromFile;
import org.apache.hadoop.utils.db.DBProfile;
import org.apache.hadoop.utils.db.DBStore;
import org.apache.hadoop.utils.db.RDBStore;
import org.apache.hadoop.utils.db.TableConfig;
import org.eclipse.jetty.util.StringUtil;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DBStoreBuilder.class);
    private Set<TableConfig> tables = new HashSet<TableConfig>();
    private DBProfile dbProfile;
    private DBOptions rocksDBOption;
    private String dbname;
    private Path dbPath;
    private List<String> tableNames = new LinkedList<String>();
    private Configuration configuration;

    private DBStoreBuilder(Configuration configuration) {
        this.configuration = configuration;
    }

    public static DBStoreBuilder newBuilder(Configuration configuration) {
        return new DBStoreBuilder(configuration);
    }

    public DBStoreBuilder setProfile(DBProfile profile) {
        this.dbProfile = profile;
        return this;
    }

    public DBStoreBuilder setName(String name) {
        this.dbname = name;
        return this;
    }

    public DBStoreBuilder addTable(String tableName) {
        this.tableNames.add(tableName);
        return this;
    }

    public DBStoreBuilder addTable(String tableName, ColumnFamilyOptions option) throws IOException {
        TableConfig tableConfig = new TableConfig(tableName, option);
        if (!this.tables.add(tableConfig)) {
            String message = "Unable to add the table: " + tableName + ".  Please check if this table name is already in use.";
            LOG.error(message);
            throw new IOException(message);
        }
        LOG.info("using custom profile for table: {}", (Object)tableName);
        return this;
    }

    public DBStoreBuilder setDBOption(DBOptions option) {
        this.rocksDBOption = option;
        return this;
    }

    public DBStoreBuilder setPath(Path path) {
        Preconditions.checkNotNull((Object)path);
        this.dbPath = path;
        return this;
    }

    public DBStore build() throws IOException {
        if (StringUtil.isBlank((String)this.dbname) || this.dbPath == null) {
            LOG.error("Required Parameter missing.");
            throw new IOException("Required parameter is missing. Please make sure sure Path and DB name is provided.");
        }
        this.processDBProfile();
        this.processTables();
        DBOptions options = this.getDbProfile();
        File dbFile = this.getDBFile();
        if (!dbFile.getParentFile().exists()) {
            throw new IOException("The DB destination directory should exist.");
        }
        return new RDBStore(dbFile, options, this.tables);
    }

    private void processDBProfile() {
        if (this.dbProfile == null) {
            this.dbProfile = (DBProfile)this.configuration.getEnum("hdds.db.profile", (Enum)HddsConfigKeys.HDDS_DEFAULT_DB_PROFILE);
        }
    }

    private void processTables() throws IOException {
        if (this.tableNames.size() > 0) {
            for (String name : this.tableNames) {
                this.addTable(name, this.dbProfile.getColumnFamilyOptions());
                LOG.info("Using default column profile:{} for Table:{}", (Object)this.dbProfile.toString(), (Object)name);
            }
        }
        this.addTable(DFSUtil.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY), this.dbProfile.getColumnFamilyOptions());
        LOG.info("Using default column profile:{} for Table:{}", (Object)this.dbProfile.toString(), (Object)DFSUtil.bytes2String((byte[])RocksDB.DEFAULT_COLUMN_FAMILY));
    }

    private DBOptions getDbProfile() {
        if (this.rocksDBOption != null) {
            return this.rocksDBOption;
        }
        DBOptions option = null;
        if (StringUtil.isNotBlank((String)this.dbname)) {
            LinkedList<ColumnFamilyDescriptor> columnFamilyDescriptors = new LinkedList<ColumnFamilyDescriptor>();
            for (TableConfig tc : this.tables) {
                columnFamilyDescriptors.add(tc.getDescriptor());
            }
            if (columnFamilyDescriptors.size() > 0) {
                try {
                    option = DBConfigFromFile.readFromFile(this.dbname, columnFamilyDescriptors);
                    if (option != null) {
                        LOG.info("Using Configs from {}.ini file", (Object)this.dbname);
                    }
                }
                catch (IOException ex) {
                    LOG.info("Unable to read ROCKDB config", (Throwable)ex);
                }
            }
        }
        if (option == null) {
            LOG.info("Using default options. {}", (Object)this.dbProfile.toString());
            return this.dbProfile.getDBOptions();
        }
        return option;
    }

    private File getDBFile() throws IOException {
        if (this.dbPath == null) {
            LOG.error("DB path is required.");
            throw new IOException("A Path to for DB file is needed.");
        }
        if (StringUtil.isBlank((String)this.dbname)) {
            LOG.error("DBName is a required.");
            throw new IOException("A valid DB name is required.");
        }
        return Paths.get(this.dbPath.toString(), this.dbname).toFile();
    }
}

