/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.utils.LevelDBStore;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.RocksDBStore;
import org.iq80.leveldb.Options;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStoreBuilder {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(MetadataStoreBuilder.class);
    private File dbFile;
    private long cacheSize;
    private boolean createIfMissing = true;
    private Optional<Configuration> optionalConf = Optional.empty();
    private String dbType;

    public static MetadataStoreBuilder newBuilder() {
        return new MetadataStoreBuilder();
    }

    public MetadataStoreBuilder setDbFile(File dbPath) {
        this.dbFile = dbPath;
        return this;
    }

    public MetadataStoreBuilder setCacheSize(long cache) {
        this.cacheSize = cache;
        return this;
    }

    public MetadataStoreBuilder setCreateIfMissing(boolean doCreate) {
        this.createIfMissing = doCreate;
        return this;
    }

    public MetadataStoreBuilder setConf(Configuration configuration) {
        this.optionalConf = Optional.of(configuration);
        return this;
    }

    public MetadataStoreBuilder setDBType(String type) {
        this.dbType = type;
        return this;
    }

    public MetadataStore build() throws IOException {
        if (this.dbFile == null) {
            throw new IllegalArgumentException("Failed to build metadata store, dbFile is required but not found");
        }
        Configuration conf = this.optionalConf.orElseGet(() -> new OzoneConfiguration());
        if (this.dbType == null) {
            LOG.debug("dbType is null, using ");
            this.dbType = conf.getTrimmed("ozone.metastore.impl", "RocksDB");
            LOG.debug("dbType is null, using dbType {} from ozone configuration", (Object)this.dbType);
        } else {
            LOG.debug("Using dbType {} for metastore", (Object)this.dbType);
        }
        if ("LevelDB".equals(this.dbType)) {
            Options options = new Options();
            options.createIfMissing(this.createIfMissing);
            if (this.cacheSize > 0L) {
                options.cacheSize(this.cacheSize);
            }
            return new LevelDBStore(this.dbFile, options);
        }
        if ("RocksDB".equals(this.dbType)) {
            String rocksDbStat;
            org.rocksdb.Options opts = new org.rocksdb.Options();
            opts.setCreateIfMissing(this.createIfMissing);
            if (this.cacheSize > 0L) {
                BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
                tableConfig.setBlockCacheSize(this.cacheSize);
                opts.setTableFormatConfig((TableFormatConfig)tableConfig);
            }
            if (!(rocksDbStat = conf.getTrimmed("ozone.metastore.rocksdb.statistics", "OFF")).equals("OFF")) {
                Statistics statistics = new Statistics();
                statistics.setStatsLevel(StatsLevel.valueOf((String)rocksDbStat));
                opts = opts.setStatistics(statistics);
            }
            return new RocksDBStore(this.dbFile, opts);
        }
        throw new IllegalArgumentException("Invalid argument for ozone.metastore.impl. Expecting LevelDB or RocksDB, but met " + this.dbType);
    }
}

