/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import com.google.common.collect.Lists;
import java.util.List;

public class BatchOperation {
    private List<SingleOperation> operations = Lists.newArrayList();

    public void put(byte[] key, byte[] value) {
        this.operations.add(new SingleOperation(Operation.PUT, key, value));
    }

    public void delete(byte[] key) {
        this.operations.add(new SingleOperation(Operation.DELETE, key, null));
    }

    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    public static class SingleOperation {
        private Operation opt;
        private byte[] key;
        private byte[] value;

        public SingleOperation(Operation opt, byte[] key, byte[] value) {
            this.opt = opt;
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            this.key = (byte[])key.clone();
            this.value = value == null ? null : (byte[])value.clone();
        }

        public Operation getOpt() {
            return this.opt;
        }

        public byte[] getKey() {
            return (byte[])this.key.clone();
        }

        public byte[] getValue() {
            return this.value == null ? null : (byte[])this.value.clone();
        }
    }

    public static enum Operation {
        DELETE,
        PUT;

    }
}

