/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectReader READER = MAPPER.readerFor(Object.class);
    private static final ObjectWriter WRITTER = MAPPER.writerWithDefaultPrettyPrinter();

    private JsonUtils() {
    }

    public static String toJsonStringWithDefaultPrettyPrinter(String jsonString) throws IOException {
        Object json = READER.readValue(jsonString);
        return WRITTER.writeValueAsString(json);
    }

    public static String toJsonString(Object obj) throws IOException {
        return MAPPER.writeValueAsString(obj);
    }

    public static List<?> toJsonList(String str, Class<?> elementType) throws IOException {
        CollectionType type = MAPPER.getTypeFactory().constructCollectionType(List.class, elementType);
        return (List)MAPPER.readValue(str, (JavaType)type);
    }
}

