/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolServerSideTranslatorPB
implements StorageContainerLocationProtocolPB {
    private final StorageContainerLocationProtocol impl;

    public StorageContainerLocationProtocolServerSideTranslatorPB(StorageContainerLocationProtocol impl) throws IOException {
        this.impl = impl;
    }

    @Override
    public StorageContainerLocationProtocolProtos.ContainerResponseProto allocateContainer(RpcController unused, StorageContainerLocationProtocolProtos.ContainerRequestProto request) throws ServiceException {
        try {
            ContainerWithPipeline containerWithPipeline = this.impl.allocateContainer(request.getReplicationType(), request.getReplicationFactor(), request.getOwner());
            return StorageContainerLocationProtocolProtos.ContainerResponseProto.newBuilder().setContainerWithPipeline(containerWithPipeline.getProtobuf()).setErrorCode(StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.GetContainerResponseProto getContainer(RpcController controller, StorageContainerLocationProtocolProtos.GetContainerRequestProto request) throws ServiceException {
        try {
            ContainerInfo container = this.impl.getContainer(request.getContainerID());
            return StorageContainerLocationProtocolProtos.GetContainerResponseProto.newBuilder().setContainerInfo(container.getProtobuf()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto getContainerWithPipeline(RpcController controller, StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request) throws ServiceException {
        try {
            ContainerWithPipeline container = this.impl.getContainerWithPipeline(request.getContainerID());
            return StorageContainerLocationProtocolProtos.GetContainerWithPipelineResponseProto.newBuilder().setContainerWithPipeline(container.getProtobuf()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.SCMListContainerResponseProto listContainer(RpcController controller, StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request) throws ServiceException {
        try {
            long startContainerID = 0L;
            int count = -1;
            if (request.hasStartContainerID()) {
                startContainerID = request.getStartContainerID();
            }
            count = request.getCount();
            List<ContainerInfo> containerList = this.impl.listContainer(startContainerID, count);
            StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerResponseProto.newBuilder();
            for (ContainerInfo container : containerList) {
                builder.addContainers(container.getProtobuf());
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto deleteContainer(RpcController controller, StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request) throws ServiceException {
        try {
            this.impl.deleteContainer(request.getContainerID());
            return StorageContainerLocationProtocolProtos.SCMDeleteContainerResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.NodeQueryResponseProto queryNode(RpcController controller, StorageContainerLocationProtocolProtos.NodeQueryRequestProto request) throws ServiceException {
        try {
            HddsProtos.NodeState nodeState = request.getState();
            List<HddsProtos.Node> datanodes = this.impl.queryNode(nodeState, request.getScope(), request.getPoolName());
            return StorageContainerLocationProtocolProtos.NodeQueryResponseProto.newBuilder().addAllDatanodes(datanodes).build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.ObjectStageChangeResponseProto notifyObjectStageChange(RpcController controller, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto request) throws ServiceException {
        try {
            this.impl.notifyObjectStageChange(request.getType(), request.getId(), request.getOp(), request.getStage());
            return StorageContainerLocationProtocolProtos.ObjectStageChangeResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.PipelineResponseProto allocatePipeline(RpcController controller, StorageContainerLocationProtocolProtos.PipelineRequestProto request) throws ServiceException {
        return null;
    }

    @Override
    public StorageContainerLocationProtocolProtos.ListPipelineResponseProto listPipelines(RpcController controller, StorageContainerLocationProtocolProtos.ListPipelineRequestProto request) throws ServiceException {
        try {
            StorageContainerLocationProtocolProtos.ListPipelineResponseProto.Builder builder = StorageContainerLocationProtocolProtos.ListPipelineResponseProto.newBuilder();
            List<Pipeline> pipelineIDs = this.impl.listPipelines();
            pipelineIDs.stream().map(Pipeline::getProtobufMessage).forEach(builder::addPipelines);
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.ClosePipelineResponseProto closePipeline(RpcController controller, StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request) throws ServiceException {
        try {
            this.impl.closePipeline(request.getPipelineID());
            return StorageContainerLocationProtocolProtos.ClosePipelineResponseProto.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public HddsProtos.GetScmInfoRespsonseProto getScmInfo(RpcController controller, HddsProtos.GetScmInfoRequestProto req) throws ServiceException {
        try {
            ScmInfo scmInfo = this.impl.getScmInfo();
            return HddsProtos.GetScmInfoRespsonseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.InChillModeResponseProto inChillMode(RpcController controller, StorageContainerLocationProtocolProtos.InChillModeRequestProto request) throws ServiceException {
        try {
            return StorageContainerLocationProtocolProtos.InChillModeResponseProto.newBuilder().setInChillMode(this.impl.inChillMode()).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public StorageContainerLocationProtocolProtos.ForceExitChillModeResponseProto forceExitChillMode(RpcController controller, StorageContainerLocationProtocolProtos.ForceExitChillModeRequestProto request) throws ServiceException {
        try {
            return StorageContainerLocationProtocolProtos.ForceExitChillModeResponseProto.newBuilder().setExitedChillMode(this.impl.forceExitChillMode()).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }
}

