/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.BlockNotCommittedException;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public final class ContainerProtocolCalls {
    private ContainerProtocolCalls() {
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, String traceID, long blockCommitSequenceId) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID).setBlockCommitSequenceId(blockCommitSequenceId);
        String id = xceiverClient.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setGetBlock(readBlockRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getGetBlock();
    }

    public static ContainerProtos.GetCommittedBlockLengthResponseProto getCommittedBlockLength(XceiverClientSpi xceiverClient, BlockID blockID, String traceID) throws IOException {
        ContainerProtos.GetCommittedBlockLengthRequestProto.Builder getBlockLengthRequestBuilder = ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        String id = xceiverClient.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetCommittedBlockLength).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setGetCommittedBlockLength(getBlockLengthRequestBuilder).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getGetCommittedBlockLength();
    }

    public static ContainerProtos.PutBlockResponseProto putBlock(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, String traceID) throws IOException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        String id = xceiverClient.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setPutBlock(createBlockRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getPutBlock();
    }

    public static ContainerProtos.ReadChunkResponseProto readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, String traceID) throws IOException {
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk);
        String id = xceiverClient.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setReadChunk(readChunkRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getReadChunk();
    }

    public static void writeChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, String traceID) throws IOException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setData(data);
        String id = xceiverClient.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setWriteChunk(writeChunkRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static void writeSmallFile(XceiverClientSpi client, BlockID blockID, byte[] data, String traceID) throws IOException {
        ContainerProtos.BlockData containerBlockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).build();
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("OverWriteRequested").setValue("true").build();
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk").setOffset(0L).setLen(data.length).addMetadata(keyValue).build();
        ContainerProtos.PutSmallFileRequestProto putSmallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder().setChunkInfo(chunk).setBlock(createBlockRequest).setData(ByteString.copyFrom((byte[])data)).build();
        String id = client.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutSmallFile).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setPutSmallFile(putSmallFileRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String traceID) throws IOException {
        ContainerProtos.CreateContainerRequestProto.Builder createRequest = ContainerProtos.CreateContainerRequestProto.newBuilder();
        createRequest.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        String id = client.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(createRequest.build());
        request.setDatanodeUuid(id);
        request.setTraceID(traceID);
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static void deleteContainer(XceiverClientSpi client, long containerID, boolean force, String traceID) throws IOException {
        ContainerProtos.DeleteContainerRequestProto.Builder deleteRequest = ContainerProtos.DeleteContainerRequestProto.newBuilder();
        deleteRequest.setForceDelete(force);
        String id = client.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.DeleteContainer);
        request.setContainerID(containerID);
        request.setDeleteContainer(deleteRequest);
        request.setTraceID(traceID);
        request.setDatanodeUuid(id);
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static void closeContainer(XceiverClientSpi client, long containerID, String traceID) throws IOException {
        String id = client.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CloseContainer);
        request.setContainerID(containerID);
        request.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        request.setTraceID(traceID);
        request.setDatanodeUuid(id);
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
    }

    public static ContainerProtos.ReadContainerResponseProto readContainer(XceiverClientSpi client, long containerID, String traceID) throws IOException {
        String id = client.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        request.setTraceID(traceID);
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build());
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getReadContainer();
    }

    public static ContainerProtos.GetSmallFileResponseProto readSmallFile(XceiverClientSpi client, BlockID blockID, String traceID) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder getBlock = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.GetSmallFileRequestProto getSmallFileRequest = ContainerProtos.GetSmallFileRequestProto.newBuilder().setBlock(getBlock).build();
        String id = client.getPipeline().getLeader().getUuidString();
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetSmallFile).setContainerID(blockID.getContainerID()).setTraceID(traceID).setDatanodeUuid(id).setGetSmallFile(getSmallFileRequest).build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request);
        ContainerProtocolCalls.validateContainerResponse(response);
        return response.getGetSmallFile();
    }

    private static void validateContainerResponse(ContainerProtos.ContainerCommandResponseProto response) throws StorageContainerException {
        if (response.getResult() == ContainerProtos.Result.SUCCESS) {
            return;
        }
        if (response.getResult() == ContainerProtos.Result.BLOCK_NOT_COMMITTED) {
            throw new BlockNotCommittedException(response.getMessage());
        }
        throw new StorageContainerException(response.getMessage(), response.getResult());
    }
}

