/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;

@InterfaceAudience.Private
public final class LocatedContainer {
    private final String key;
    private final String matchedKeyPrefix;
    private final String containerName;
    private final Set<DatanodeInfo> locations;
    private final DatanodeInfo leader;

    public LocatedContainer(String key, String matchedKeyPrefix, String containerName, Set<DatanodeInfo> locations, DatanodeInfo leader) {
        this.key = key;
        this.matchedKeyPrefix = matchedKeyPrefix;
        this.containerName = containerName;
        this.locations = locations;
        this.leader = leader;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getKey() {
        return this.key;
    }

    public DatanodeInfo getLeader() {
        return this.leader;
    }

    public Set<DatanodeInfo> getLocations() {
        return this.locations;
    }

    public String getMatchedKeyPrefix() {
        return this.matchedKeyPrefix;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof LocatedContainer)) {
            return false;
        }
        LocatedContainer other = (LocatedContainer)otherObj;
        return this.key == null ? other.key == null : this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{key=" + this.key + "; matchedKeyPrefix=" + this.matchedKeyPrefix + "; containerName=" + this.containerName + "; locations=" + this.locations + "; leader=" + this.leader + "}";
    }
}

