/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;

public final class Pipeline {
    private final PipelineID id;
    private final HddsProtos.ReplicationType type;
    private final HddsProtos.ReplicationFactor factor;
    private HddsProtos.LifeCycleState state;
    private List<DatanodeDetails> nodes;

    private Pipeline(PipelineID id, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.LifeCycleState state, List<DatanodeDetails> nodes) {
        this.id = id;
        this.type = type;
        this.factor = factor;
        this.state = state;
        this.nodes = nodes;
    }

    public PipelineID getID() {
        return this.id;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public HddsProtos.LifeCycleState getLifeCycleState() {
        return this.state;
    }

    public List<DatanodeDetails> getNodes() {
        return new ArrayList<DatanodeDetails>(this.nodes);
    }

    public HddsProtos.Pipeline getProtobufMessage() {
        HddsProtos.Pipeline.Builder builder = HddsProtos.Pipeline.newBuilder();
        builder.setId(this.id.getProtobuf());
        builder.setType(this.type);
        builder.setState(this.state);
        builder.addAllMembers(this.nodes.stream().map(DatanodeDetails::getProtoBufMessage).collect(Collectors.toList()));
        return builder.build();
    }

    public static Pipeline fromProtobuf(HddsProtos.Pipeline pipeline) {
        return new Pipeline(PipelineID.getFromProtobuf(pipeline.getId()), pipeline.getType(), pipeline.getFactor(), pipeline.getState(), pipeline.getMembersList().stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline that = (Pipeline)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.type, (Object)that.type).append((Object)this.factor, (Object)that.factor).append((Object)this.state, (Object)that.state).append(this.nodes, that.nodes).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.type).append((Object)this.factor).append((Object)this.state).append(this.nodes).toHashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Pipeline pipeline) {
        return new Builder(pipeline);
    }

    public static class Builder {
        private PipelineID id = null;
        private HddsProtos.ReplicationType type = null;
        private HddsProtos.ReplicationFactor factor = null;
        private HddsProtos.LifeCycleState state = null;
        private List<DatanodeDetails> nodes = null;

        public Builder() {
        }

        public Builder(Pipeline pipeline) {
            this.id = pipeline.getID();
            this.type = pipeline.getType();
            this.factor = pipeline.getFactor();
            this.state = pipeline.getLifeCycleState();
            this.nodes = pipeline.getNodes();
        }

        public Builder setId(PipelineID id1) {
            this.id = id1;
            return this;
        }

        public Builder setType(HddsProtos.ReplicationType type1) {
            this.type = type1;
            return this;
        }

        public Builder setFactor(HddsProtos.ReplicationFactor factor1) {
            this.factor = factor1;
            return this;
        }

        public Builder setState(HddsProtos.LifeCycleState state1) {
            this.state = state1;
            return this;
        }

        public Builder setNodes(List<DatanodeDetails> nodes1) {
            this.nodes = nodes1;
            return this;
        }

        public Pipeline build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)((Object)this.type));
            Preconditions.checkNotNull((Object)((Object)this.factor));
            Preconditions.checkNotNull((Object)((Object)this.state));
            Preconditions.checkNotNull(this.nodes);
            return new Pipeline(this.id, this.type, this.factor, this.state, this.nodes);
        }
    }
}

