/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class OzoneConfiguration
extends Configuration {
    public OzoneConfiguration() {
        OzoneConfiguration.activate();
    }

    public OzoneConfiguration(Configuration conf) {
        super(conf);
    }

    public List<Property> readPropertyFromXml(URL url) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLConfiguration.class});
        Unmarshaller um = context.createUnmarshaller();
        XMLConfiguration config = (XMLConfiguration)um.unmarshal(url);
        return config.getProperties();
    }

    public static void activate() {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Configuration.addDefaultResource((String)"ozone-default.xml");
        Configuration.addDefaultResource((String)"ozone-site.xml");
    }

    static {
        OzoneConfiguration.activate();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="property")
    public static class Property
    implements Comparable<Property> {
        private String name;
        private String value;
        private String tag;
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int compareTo(Property o) {
            if (this == o) {
                return 0;
            }
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return this.getName() + " " + this.getValue() + " " + this.getTag();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Property && ((Property)obj).getName().equals(this.getName());
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="configuration")
    public static class XMLConfiguration {
        @XmlElement(name="property", type=Property.class)
        private List<Property> properties = new ArrayList<Property>();

        public XMLConfiguration() {
        }

        public XMLConfiguration(List<Property> properties) {
            this.properties = properties;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void setProperties(List<Property> properties) {
            this.properties = properties;
        }
    }
}

