/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class BlockID {
    private long containerID;
    private long localID;

    public BlockID(long containerID, long localID) {
        this.containerID = containerID;
        this.localID = localID;
    }

    public long getContainerID() {
        return this.containerID;
    }

    public long getLocalID() {
        return this.localID;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("containerID", this.containerID).append("localID", this.localID).toString();
    }

    public HddsProtos.BlockID getProtobuf() {
        return HddsProtos.BlockID.newBuilder().setContainerID(this.containerID).setLocalID(this.localID).build();
    }

    public static BlockID getFromProtobuf(HddsProtos.BlockID blockID) {
        return new BlockID(blockID.getContainerID(), blockID.getLocalID());
    }

    public ContainerProtos.DatanodeBlockID getDatanodeBlockIDProtobuf() {
        return ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(this.containerID).setLocalID(this.localID).build();
    }

    public static BlockID getFromProtobuf(ContainerProtos.DatanodeBlockID blockID) {
        return new BlockID(blockID.getContainerID(), blockID.getLocalID());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockID blockID = (BlockID)o;
        return this.containerID == blockID.containerID && this.localID == blockID.localID;
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.localID);
    }
}

