/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Closeable;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ReadStatistics;
import org.slf4j.Logger;

public class IOUtilsClient {
    public static void cleanupWithLogger(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing " + c, e);
            }
        }
    }

    public static void updateReadStatistics(ReadStatistics readStatistics, int nRead, BlockReader blockReader) {
        if (nRead <= 0) {
            return;
        }
        if (blockReader.isShortCircuit()) {
            readStatistics.addShortCircuitBytes(nRead);
        } else if (blockReader.getNetworkDistance() == 0) {
            readStatistics.addLocalBytes(nRead);
        } else {
            readStatistics.addRemoteBytes(nRead);
        }
    }
}

