/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.ReadStatistics;
import org.apache.hadoop.hdfs.ReaderStrategy;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.util.IOUtilsClient;

class ByteBufferStrategy
implements ReaderStrategy {
    private final DFSClient dfsClient;
    private final ReadStatistics readStatistics;
    private final ByteBuffer readBuf;
    private final int targetLength;

    ByteBufferStrategy(ByteBuffer readBuf, ReadStatistics readStatistics, DFSClient dfsClient) {
        this.readBuf = readBuf;
        this.targetLength = readBuf.remaining();
        this.readStatistics = readStatistics;
        this.dfsClient = dfsClient;
    }

    @Override
    public ByteBuffer getReadBuffer() {
        return this.readBuf;
    }

    @Override
    public int readFromBlock(BlockReader blockReader) throws IOException {
        return this.readFromBlock(blockReader, this.readBuf.remaining());
    }

    @Override
    public int readFromBlock(BlockReader blockReader, int length) throws IOException {
        ByteBuffer tmpBuf = this.readBuf.duplicate();
        tmpBuf.limit(tmpBuf.position() + length);
        int nRead = blockReader.read(tmpBuf);
        if (nRead > 0) {
            this.readBuf.position(this.readBuf.position() + nRead);
            IOUtilsClient.updateReadStatistics(this.readStatistics, nRead, blockReader);
            this.dfsClient.updateFileSystemReadStats(blockReader.getNetworkDistance(), nRead);
            if (this.readStatistics.getBlockType() == BlockType.STRIPED) {
                this.dfsClient.updateFileSystemECReadStats(nRead);
            }
        }
        return nRead;
    }

    @Override
    public int getTargetLength() {
        return this.targetLength;
    }

    @Override
    public int readFromBuffer(ByteBuffer src) {
        return this.readFromBuffer(src, src.remaining());
    }

    @Override
    public int readFromBuffer(ByteBuffer src, int length) {
        ByteBuffer dup = src.duplicate();
        int newLen = Math.min(this.readBuf.remaining(), dup.remaining());
        newLen = Math.min(newLen, length);
        dup.limit(dup.position() + newLen);
        this.readBuf.put(dup);
        return newLen;
    }
}

