/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.rest.response.VolumeInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List the volumes of a given user"})
public class ListVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."}, defaultValue="/")
    private String uri;
    @CommandLine.Option(names={"--length", "-l"}, description={"Limit of the max results"}, defaultValue="100")
    private int maxVolumes;
    @CommandLine.Option(names={"--start", "-s"}, description={"The first volume to start the listing"})
    private String startVolume;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Prefix to filter the volumes"})
    private String prefix;
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of the volumes to list."})
    private String userName;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        if (!Strings.isNullOrEmpty((String)ozoneURI.getPath()) && !ozoneURI.getPath().equals("/")) {
            throw new OzoneClientException("Invalid URI: " + ozoneURI + " . Specified path not used." + ozoneURI.getPath());
        }
        if (this.userName == null) {
            this.userName = System.getProperty("user.name");
        }
        if (this.maxVolumes < 1) {
            throw new IllegalArgumentException("the length should be a positive number");
        }
        Iterator volumeIterator = this.userName != null ? this.client.getObjectStore().listVolumesByUser(this.userName, this.prefix, this.startVolume) : this.client.getObjectStore().listVolumes(this.prefix);
        ArrayList<VolumeInfo> volumeInfos = new ArrayList<VolumeInfo>();
        while (this.maxVolumes > 0 && volumeIterator.hasNext()) {
            VolumeInfo volume = OzoneClientUtils.asVolumeInfo((OzoneVolume)((OzoneVolume)volumeIterator.next()));
            volumeInfos.add(volume);
            --this.maxVolumes;
        }
        if (this.isVerbose()) {
            System.out.printf("Found : %d volumes for user : %s ", volumeInfos.size(), this.userName);
        }
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString(volumeInfos)));
        return null;
    }
}

