/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"returns information about a specific volume"})
public class InfoVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;

    @Override
    public Void call() throws Exception {
        String volumeName = this.parseVolumeName(this.uri);
        OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
        System.out.printf("%s%n", JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString((Object)OzoneClientUtils.asVolumeInfo((OzoneVolume)vol))));
        return null;
    }
}

