/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import picocli.CommandLine;

@CommandLine.Command(name="put", description={"creates or overwrites an existing key"})
public class PutKeyHandler
extends Handler {
    @CommandLine.Parameters(index="0", arity="1..1", description={"URI of the volume/bucket/key.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Parameters(index="1", arity="1..1", description={"File to upload"})
    private String fileName;
    @CommandLine.Option(names={"-r", "--replication"}, description={"Replication factor of the new key. (use ONE or THREE) Default is specified in the cluster-wide config."})
    private ReplicationFactor replicationFactor;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        if (path.getNameCount() < 3) {
            throw new OzoneClientException("volume/bucket/key name required in putKey");
        }
        String volumeName = path.getName(0).toString();
        String bucketName = path.getName(1).toString();
        String keyName = path.getName(2).toString();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
            System.out.printf("Key Name : %s%n", keyName);
        }
        File dataFile = new File(this.fileName);
        if (this.isVerbose()) {
            FileInputStream stream = new FileInputStream(dataFile);
            String hash = DigestUtils.md5Hex((InputStream)stream);
            System.out.printf("File Hash : %s%n", hash);
            stream.close();
        }
        OzoneConfiguration conf = new OzoneConfiguration();
        if (this.replicationFactor == null) {
            this.replicationFactor = ReplicationFactor.valueOf((int)conf.getInt("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT));
        }
        ReplicationType replicationType = ReplicationType.valueOf((String)conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        OzoneOutputStream outputStream = bucket.createKey(keyName, dataFile.length(), replicationType, this.replicationFactor);
        FileInputStream fileInputStream = new FileInputStream(dataFile);
        IOUtils.copyBytes((InputStream)fileInputStream, (OutputStream)outputStream, (int)conf.getInt("ozone.scm.chunk.size", 0x1000000));
        outputStream.close();
        fileInputStream.close();
        return null;
    }
}

