/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"deletes an existing key"})
public class DeleteKeyHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket/key.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        if (path.getNameCount() < 3) {
            throw new OzoneClientException("volume/bucket/key name required in deleteKey");
        }
        String volumeName = path.getName(0).toString();
        String bucketName = path.getName(1).toString();
        String keyName = path.getName(2).toString();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
            System.out.printf("Key Name : %s%n", keyName);
        }
        OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        bucket.deleteKey(keyName);
        return null;
    }
}

