/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import picocli.CommandLine;

@CommandLine.Command(name="path", description={"Returns the ozone path for S3Bucket"})
public class S3BucketMapping
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the S3Bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;

    @Override
    public Void call() throws Exception {
        String s3Bucket;
        URI ozoneURI = this.verifyURI(this.uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        int pathNameCount = path.getNameCount();
        if (pathNameCount == 1 && StringUtils.isBlank((CharSequence)(s3Bucket = path.getName(0).toString()))) {
            String errorMessage = "S3Bucket name is required to get volume name and Ozone fs Uri";
            throw new OzoneClientException(errorMessage);
        }
        if (pathNameCount != 1) {
            String errorMessage = pathNameCount < 1 ? "S3Bucket name is required to get volume name and Ozone fs Uri" : "Invalid S3Bucket name. Delimiters (/) not allowed in S3Bucket name";
            throw new OzoneClientException(errorMessage);
        }
        s3Bucket = path.getName(0).toString();
        if (this.isVerbose()) {
            System.out.printf("S3Bucket Name : %s%n", s3Bucket);
        }
        String mapping = this.client.getObjectStore().getOzoneBucketMapping(s3Bucket);
        String volumeName = this.client.getObjectStore().getOzoneVolumeName(s3Bucket);
        if (this.isVerbose()) {
            System.out.printf("Mapping created for S3Bucket is : %s%n", mapping);
        }
        System.out.printf("Volume name for S3Bucket is : %s%n", volumeName);
        String ozoneFsUri = String.format("%s://%s.%s", "o3fs", s3Bucket, volumeName);
        System.out.printf("Ozone FileSystem Uri is : %s%n", ozoneFsUri);
        return null;
    }
}

