/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.rest.response.BucketInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"lists the buckets in a volume."})
public class ListBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--length", "-l"}, description={"Limit of the max results"}, defaultValue="100", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int maxBuckets;
    @CommandLine.Option(names={"--start", "-s"}, description={"The first bucket to start the listing"})
    private String startBucket;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Prefix to filter the buckets"})
    private String prefix;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        int pathNameCount = path.getNameCount();
        if (pathNameCount != 1) {
            String errorMessage = pathNameCount < 1 ? "volume is required in listBucket" : "Invalid volume name. Delimiters (/) not allowed in volume name";
            throw new OzoneClientException(errorMessage);
        }
        if (this.maxBuckets < 1) {
            throw new IllegalArgumentException("the length should be a positive number");
        }
        String volumeName = path.getName(0).toString();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
        }
        OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
        Iterator bucketIterator = vol.listBuckets(this.prefix, this.startBucket);
        ArrayList<BucketInfo> bucketList = new ArrayList<BucketInfo>();
        while (this.maxBuckets > 0 && bucketIterator.hasNext()) {
            BucketInfo bucketInfo = OzoneClientUtils.asBucketInfo((OzoneBucket)((OzoneBucket)bucketIterator.next()));
            bucketList.add(bucketInfo);
            --this.maxBuckets;
        }
        if (this.isVerbose()) {
            System.out.printf("Found : %d buckets for volume : %s ", bucketList.size(), volumeName);
        }
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString(bucketList)));
        return null;
    }
}

