/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell;

import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.web.ozShell.bucket.BucketCommands;
import org.apache.hadoop.ozone.web.ozShell.keys.KeyCommands;
import org.apache.hadoop.ozone.web.ozShell.volume.VolumeCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone sh", description={"Shell for Ozone object store"}, subcommands={VolumeCommands.class, BucketCommands.class, KeyCommands.class}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class Shell
extends GenericCli {
    private static final Logger LOG = LoggerFactory.getLogger(Shell.class);
    public static final String OZONE_URI_DESCRIPTION = "Ozone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files.";
    public static final String OZONE_VOLUME_URI_DESCRIPTION = "URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files.";
    public static final String OZONE_BUCKET_URI_DESCRIPTION = "URI of the volume/bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files.";
    public static final String OZONE_KEY_URI_DESCRIPTION = "URI of the volume/bucket/key.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files.";
    public static final String OZONE_S3BUCKET_URI_DESCRIPTION = "URI of the S3Bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files.";
    public static final int DEFAULT_OZONE_PORT = 50070;

    public static void main(String[] argv) throws Exception {
        new Shell().run(argv);
    }
}

