/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public abstract class Handler
implements Callable<Void> {
    protected static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    protected OzoneClient client;
    @CommandLine.ParentCommand
    private GenericParentCommand parent;

    @Override
    public Void call() throws Exception {
        throw new UnsupportedOperationException();
    }

    protected URI verifyURI(String uri) throws URISyntaxException, OzoneException, IOException {
        if (uri == null || uri.isEmpty()) {
            throw new OzoneClientException("Ozone URI is needed to execute this command.");
        }
        URIBuilder ozoneURI = new URIBuilder(Handler.stringToUri(uri));
        if (ozoneURI.getPort() == 0) {
            ozoneURI.setPort(50070);
        }
        OzoneConfiguration conf = new OzoneConfiguration();
        String scheme = ozoneURI.getScheme();
        if (ozoneURI.getScheme() == null || scheme.isEmpty()) {
            scheme = "o3";
        }
        if (scheme.equals("http")) {
            this.client = ozoneURI.getHost() != null ? (ozoneURI.getPort() == -1 ? OzoneClientFactory.getRestClient((String)ozoneURI.getHost()) : OzoneClientFactory.getRestClient((String)ozoneURI.getHost(), (Integer)ozoneURI.getPort(), (Configuration)conf)) : OzoneClientFactory.getRestClient((Configuration)conf);
        } else if (scheme.equals("o3")) {
            this.client = ozoneURI.getHost() != null ? (ozoneURI.getPort() == -1 ? OzoneClientFactory.getRpcClient((String)ozoneURI.getHost()) : OzoneClientFactory.getRpcClient((String)ozoneURI.getHost(), (Integer)ozoneURI.getPort(), (Configuration)conf)) : OzoneClientFactory.getRpcClient((Configuration)conf);
        } else {
            throw new OzoneClientException("Invalid URI: " + ozoneURI);
        }
        return ozoneURI.build();
    }

    private static URI stringToUri(String pathString) throws IOException {
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon > 0 && slash == colon + 1) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start += 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        try {
            return new URI(scheme, authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String parseVolumeName(String uri) throws Exception {
        URI ozoneURI = this.verifyURI(uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        int pathNameCount = path.getNameCount();
        if (pathNameCount != 1) {
            String errorMessage = pathNameCount < 1 ? "Volume name is required to perform volume operations like info, update, create and delete. " : "Invalid volume name. Delimiters (/) not allowed in volume name";
            throw new OzoneClientException(errorMessage);
        }
        return ozoneURI.getPath().replaceAll("^/+", "");
    }

    public boolean isVerbose() {
        return this.parent.isVerbose();
    }
}

