/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.lock.LockManager;

public final class OzoneManagerLock {
    private static final String VOLUME_LOCK = "volumeLock";
    private static final String BUCKET_LOCK = "bucketLock";
    private static final String S3_BUCKET_LOCK = "s3BucketLock";
    private final LockManager<String> manager;
    private final ThreadLocal<Map<String, AtomicInteger>> myLocks = ThreadLocal.withInitial(() -> ImmutableMap.of((Object)VOLUME_LOCK, (Object)new AtomicInteger(0), (Object)BUCKET_LOCK, (Object)new AtomicInteger(0), (Object)S3_BUCKET_LOCK, (Object)new AtomicInteger(0)));

    public OzoneManagerLock(Configuration conf) {
        this.manager = new LockManager(conf);
    }

    public void acquireUserLock(String user) {
        if (this.hasAnyVolumeLock() || this.hasAnyBucketLock() || this.hasAnyS3Lock()) {
            throw new RuntimeException("Thread '" + Thread.currentThread().getName() + "' cannot acquire user lock while holding volume, bucket or S3 bucket lock(s).");
        }
        this.manager.lock((Object)("$" + user));
    }

    public void releaseUserLock(String user) {
        this.manager.unlock((Object)("$" + user));
    }

    public void acquireVolumeLock(String volume) {
        if (this.hasAnyBucketLock()) {
            throw new RuntimeException("Thread '" + Thread.currentThread().getName() + "' cannot acquire volume lock while holding bucket lock(s).");
        }
        this.manager.lock((Object)("/" + volume));
        this.myLocks.get().get(VOLUME_LOCK).incrementAndGet();
    }

    public void releaseVolumeLock(String volume) {
        this.manager.unlock((Object)("/" + volume));
        this.myLocks.get().get(VOLUME_LOCK).decrementAndGet();
    }

    public void acquireS3Lock(String s3BucketName) {
        if (this.hasAnyBucketLock()) {
            throw new RuntimeException("Thread '" + Thread.currentThread().getName() + "' cannot acquire S3 bucket lock while holding Ozone bucket lock(s).");
        }
        this.manager.lock((Object)("S3:" + s3BucketName));
        this.myLocks.get().get(S3_BUCKET_LOCK).incrementAndGet();
    }

    public void releaseS3Lock(String s3BucketName) {
        this.manager.unlock((Object)("S3:" + s3BucketName));
        this.myLocks.get().get(S3_BUCKET_LOCK).decrementAndGet();
    }

    public void acquireBucketLock(String volume, String bucket) {
        this.manager.lock((Object)("/" + volume + "/" + bucket));
        this.myLocks.get().get(BUCKET_LOCK).incrementAndGet();
    }

    public void releaseBucketLock(String volume, String bucket) {
        this.manager.unlock((Object)("/" + volume + "/" + bucket));
        this.myLocks.get().get(BUCKET_LOCK).decrementAndGet();
    }

    private boolean hasAnyVolumeLock() {
        return this.myLocks.get().get(VOLUME_LOCK).get() != 0;
    }

    private boolean hasAnyBucketLock() {
        return this.myLocks.get().get(BUCKET_LOCK).get() != 0;
    }

    private boolean hasAnyS3Lock() {
        return this.myLocks.get().get(S3_BUCKET_LOCK).get() != 0;
    }
}

