/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.OzoneManagerLock;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.utils.db.DBStore;
import org.apache.hadoop.utils.db.Table;

public interface OMMetadataManager {
    public void start();

    public void stop() throws Exception;

    @VisibleForTesting
    public DBStore getStore();

    public OzoneManagerLock getLock();

    public byte[] getVolumeKey(String var1);

    public byte[] getUserKey(String var1);

    public byte[] getBucketKey(String var1, String var2);

    public byte[] getOzoneKeyBytes(String var1, String var2, String var3);

    public byte[] getOpenKeyBytes(String var1, String var2, String var3, long var4);

    public boolean isVolumeEmpty(String var1) throws IOException;

    public boolean isBucketEmpty(String var1, String var2) throws IOException;

    public List<OmBucketInfo> listBuckets(String var1, String var2, String var3, int var4) throws IOException;

    public List<OmKeyInfo> listKeys(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public List<OmVolumeArgs> listVolumes(String var1, String var2, String var3, int var4) throws IOException;

    public List<BlockGroup> getPendingDeletionKeys(int var1) throws IOException;

    public List<BlockGroup> getExpiredOpenKeys() throws IOException;

    public Table getUserTable();

    public Table getVolumeTable();

    public Table getBucketTable();

    public Table getKeyTable();

    public Table getDeletedTable();

    public Table getOpenKeyTable();

    public Table getS3Table();
}

